/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import camundajar.impl.com.google.gson.Gson;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineBootstrapCommand;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.camunda.bpm.engine.impl.telemetry.dto.Command;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.dto.Database;
import org.camunda.bpm.engine.impl.telemetry.dto.Internals;
import org.camunda.bpm.engine.impl.telemetry.dto.Jdk;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyData;
import org.camunda.bpm.engine.impl.telemetry.dto.Metric;
import org.camunda.bpm.engine.impl.telemetry.dto.Product;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class TelemetryReporterTest {
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8084/pings";
    private static final String TELEMETRY_ENDPOINT_PATH = "/pings";
    public static String DMN_FILE = "org/camunda/bpm/engine/test/api/mgmt/metrics/ExecutedDecisionElementsTest.dmn11.xml";
    public static VariableMap VARIABLES = Variables.createVariables().putValue("status", (Object)"").putValue("sum", (Object)100);
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setTelemetryReporterActivate(true).setProcessEngineBootstrapCommand((ProcessEngineBootstrapCommand)new BootstrapEngineCommand(){

        protected void initializeInitialTelemetryMessage() {
            this.sendInitialTelemetryMessage = false;
        }
    }));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    @ClassRule
    public static WireMockRule wireMockRule = new WireMockRule(8084);
    protected ProcessEngine standaloneProcessEngine;
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected TelemetryReporter standaloneReporter;
    protected Data defaultTelemetryData;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.configuration.getManagementService();
        this.runtimeService = this.configuration.getRuntimeService();
        this.taskService = this.configuration.getTaskService();
        this.identityService = this.configuration.getIdentityService();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.configuration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        this.clearMetrics();
        this.configuration.getTelemetryRegistry().clear();
        this.defaultTelemetryData = new Data(this.configuration.getTelemetryData());
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        ClockUtil.resetClock();
        if (Boolean.TRUE.equals(this.managementService.isTelemetryEnabled())) {
            this.managementService.toggleTelemetry(false);
        }
        this.clearMetrics();
        if (this.standaloneReporter != null) {
            this.standaloneReporter.stop(false);
            this.standaloneReporter = null;
        }
        if (this.standaloneProcessEngine != null) {
            if (Boolean.TRUE.equals(this.standaloneProcessEngine.getManagementService().isTelemetryEnabled())) {
                this.standaloneProcessEngine.getManagementService().toggleTelemetry(false);
            }
            this.standaloneProcessEngine.close();
        }
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.configuration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
        WireMock.resetAllRequests();
        this.configuration.setTelemetryData(this.defaultTelemetryData);
    }

    protected void clearMetrics() {
        Collection meters = this.configuration.getMetricsRegistry().getDbMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    public void shouldSendTelemetry() {
        this.managementService.toggleTelemetry(true);
        Data data = this.createDataToSend();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, 0, 1000L, data, this.configuration.getTelemetryHttpConnector(), this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout());
        this.standaloneReporter.reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportDataWhenTelemetryInitialized() {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setInitializeTelemetry(true).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldNotReportInitialDataWhenReporterActivatedAndInitTelemetryUndefinedDuringProcessEngineClose() {
        this.createEngineWithInitMessage(null);
        this.standaloneProcessEngine.close();
        this.standaloneProcessEngine = null;
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
    }

    @Test
    public void shouldNotReportInitialDataWhenReporterActivatedAndInitTelemetryDisabledDuringProcessEngineClose() {
        this.createEngineWithInitMessage(false);
        this.standaloneProcessEngine.close();
        this.standaloneProcessEngine = null;
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
    }

    @Test
    public void shouldNotReportInitialDataWhenReporterActivatedAndInitTelemetryEnabledDuringProcessEngineClose() {
        this.createEngineWithInitMessage(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneProcessEngine.close();
        this.standaloneProcessEngine = null;
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportInitialDataWhenReporterActivatedAndInitTelemetryUndefined() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(null);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Data expectedData = this.createInitialDataToSend(processEngineConfiguration.getTelemetryData(), null);
        String requestBody = new Gson().toJson((Object)expectedData);
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportInitialDataWhenReporterActivatedAndInitTelemetryDisabled() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(false);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Data expectedData = this.createInitialDataToSend(processEngineConfiguration.getTelemetryData(), false);
        String requestBody = new Gson().toJson((Object)expectedData);
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportInitialDataWhenReporterActivatedAndInitTelemetryEnabled() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Data expectedData = this.createInitialDataToSend(processEngineConfiguration.getTelemetryData(), true);
        String requestBody = new Gson().toJson((Object)expectedData);
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportInitialDataOnlyOnceInitTelemetryUndefinedReportPlusClose() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(null);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Data expectedData = this.createInitialDataToSend(processEngineConfiguration.getTelemetryData(), null);
        String requestBody = new Gson().toJson((Object)expectedData);
        processEngineConfiguration.getTelemetryReporter().reportNow();
        this.standaloneProcessEngine.close();
        this.standaloneProcessEngine = null;
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportInitialDataOnlyOnceInitTelemetryDisabledReportPlusClose() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(false);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Data expectedData = this.createInitialDataToSend(processEngineConfiguration.getTelemetryData(), false);
        String requestBody = new Gson().toJson((Object)expectedData);
        processEngineConfiguration.getTelemetryReporter().reportNow();
        this.standaloneProcessEngine.close();
        this.standaloneProcessEngine = null;
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldReportInitialDataOnlyOnceInitTelemetryEnabledReportPlusClose() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Data expectedData = this.createInitialDataToSend(processEngineConfiguration.getTelemetryData(), true);
        String requestBody = new Gson().toJson((Object)expectedData);
        processEngineConfiguration.getTelemetryReporter().reportNow();
        this.standaloneProcessEngine.close();
        this.standaloneProcessEngine = null;
        WireMock.verify((int)3, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending initial telemetry data").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Initial telemetry request was successful.").size()).isOne();
    }

    @Test
    public void shouldReportInitialDataOnlyOnceWhenReportingTwice() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(false);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Data expectedData = this.createInitialDataToSend(processEngineConfiguration.getTelemetryData(), false);
        String requestBody = new Gson().toJson((Object)expectedData);
        processEngineConfiguration.getTelemetryReporter().reportNow();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldNotReportInitialDataWhenReporterDeactivated() {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setTelemetryReporterActivate(false).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
    }

    @Test
    public void shouldSendTelemetryWithApplicationServerInfo() {
        this.managementService.toggleTelemetry(true);
        String applicationServerVersion = "Tomcat 10";
        this.configuration.getTelemetryRegistry().setApplicationServer(applicationServerVersion);
        Data expectedData = this.adjustDataWithAppServerInfo(this.configuration.getTelemetryData(), applicationServerVersion);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithLicenseInfo() {
        this.managementService.toggleTelemetry(true);
        LicenseKeyData licenseKey = new LicenseKeyData("customer a", "UNIFIED", "2029-09-01", Boolean.valueOf(false), Collections.singletonMap("camundaBPM", "true"), "raw license");
        this.configuration.getTelemetryRegistry().setLicenseKey(licenseKey);
        Data expectedData = this.adjustDataWithLicenseInfo(this.configuration.getTelemetryData(), licenseKey);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithOverriddenLicenseInfo() {
        this.managementService.toggleTelemetry(true);
        LicenseKeyData licenseKey = new LicenseKeyData("customer a", "UNIFIED", "2029-09-01", Boolean.valueOf(false), Collections.singletonMap("camundaBPM", "true"), "raw license");
        this.configuration.getTelemetryRegistry().setLicenseKey(licenseKey);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        this.configuration.getTelemetryRegistry().getCommands().clear();
        licenseKey = new LicenseKeyData("customer b", "UNIFIED", "2029-08-01", Boolean.valueOf(false), Collections.singletonMap("cawemo", "true"), "new raw license");
        this.configuration.getTelemetryRegistry().setLicenseKey(licenseKey);
        Data expectedData = this.adjustDataWithLicenseInfo(this.configuration.getTelemetryData(), licenseKey);
        String requestBody = new Gson().toJson((Object)expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithRawLicenseInfoOnly() {
        this.managementService.toggleTelemetry(true);
        String licenseKeyRaw = "raw license";
        this.managementService.setLicenseKey(licenseKeyRaw);
        Data expectedData = this.adjustDataWithRawLicenseInfo(this.configuration.getTelemetryData(), licenseKeyRaw);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        this.managementService.deleteLicenseKey();
    }

    @Test
    public void shouldSendTelemetryWithCommandCounts() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        Data expectedData = this.adjustDataWithCommandCounts(this.configuration.getTelemetryData());
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithRooProcessInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 3L, 0L, 0L, 6L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotSendMetricsTwice() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 0L, 0L, 0L, 0L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    public void shouldSendTelemetryWithExecutedDecisionInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 2; ++i) {
            this.runtimeService.startProcessInstanceByKey("testProcess");
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 2L, 2L, 2L, 4L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/metrics/ExecutedDecisionElementsTest.dmn11.xml"})
    public void shouldSendTelemetryWithExecutedDecisionElementMetrics() {
        BpmnModelInstance modelInstance = this.createProcessWithBusinessRuleTask("testProcess", "decision");
        this.testRule.deploy(this.configuration.getRepositoryService().createDeployment().addModelInstance("process.bpmn", modelInstance).addClasspathResource(DMN_FILE));
        this.managementService.toggleTelemetry(true);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)VARIABLES);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 1L, 16L, 1L, 3L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithActivityInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 4; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 4L, 0L, 0L, 12L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithTaskWorkersMetrics() {
        this.managementService.toggleTelemetry(true);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        for (int i = 0; i < 3; ++i) {
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
            String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult()).getId();
            this.taskService.setAssignee(taskId, "user" + i);
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 3L, 0L, 0L, 6L, 3L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldAddJdkInfoToTelemetryData() {
        Data telemetryData = this.configuration.getTelemetryData();
        Jdk jdkInfo = telemetryData.getProduct().getInternals().getJdk();
        Assertions.assertThat((Object)jdkInfo).isNotNull();
        Jdk expectedJdkInfo = ParseUtil.parseJdkDetails();
        Assertions.assertThat((String)jdkInfo.getVersion()).isEqualTo((Object)expectedJdkInfo.getVersion());
        Assertions.assertThat((String)jdkInfo.getVendor()).isEqualTo((Object)expectedJdkInfo.getVendor());
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetrySent() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Start telemetry sending task").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending telemetry data").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Telemetry request was successful.").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogInitialTelemetrySent() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(false);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        processEngineConfiguration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Start telemetry sending task").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending initial telemetry data").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Initial telemetry request was successful.").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogUnexpectedResponse() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(406)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Unexpected response code 406 when sending telemetry data").size()).isEqualTo(3);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogUnexpectedResponseOnInitialMessage() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createEngineWithInitMessage(false);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(406)));
        processEngineConfiguration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Unexpected response code 406 when sending initial telemetry data").size()).isEqualTo(3);
    }

    @Test
    public void shouldNotSendTelemetryWhenDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryReporter telemetryReporter = this.configuration.getTelemetryReporter();
        telemetryReporter.reportNow();
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending telemetry is disabled").size()).isOne();
    }

    @Test
    public void shouldKeepReporterRunningAfterTelemetryIsDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryReporter telemetryReporter = this.configuration.getTelemetryReporter();
        Assertions.assertThat((boolean)telemetryReporter.isScheduled()).isTrue();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogErrorOnDebugWhenHttpConnectorNotInitialized() {
        this.managementService.toggleTelemetry(true);
        Data data = this.createDataToSend();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, 0, 1000L, data, null, this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout());
        this.standaloneReporter.reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Could not send telemetry data. Reason: NullPointerException with message 'null'. Set this logger to DEBUG/FINE for the full stacktrace.").size()).isOne();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldRecordUserOperationLog() {
        this.configuration.getIdentityService().setAuthenticatedUserId("admin");
        this.managementService.toggleTelemetry(true);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.configuration.getHistoryService().createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Property");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Admin");
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"Update");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"name");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)"camunda.telemetry.enabled");
    }

    @Test
    public void shouldMakeRetriesOnNonSuccessStatus() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(500)));
        Data expectedData = this.adjustDataWithCommandCounts(this.configuration.getTelemetryData());
        String expectedRequestBody = new Gson().toJson((Object)expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((int)3, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)expectedRequestBody, (JSONCompareMode)JSONCompareMode.LENIENT)));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotMakeRetriesOnUnexpectedSuccessStatus() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(204)));
        Data expectedData = this.adjustDataWithCommandCounts(this.configuration.getTelemetryData());
        String expectedRequestBody = new Gson().toJson((Object)expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)expectedRequestBody, (JSONCompareMode)JSONCompareMode.LENIENT)));
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Telemetry request was sent, but received an unexpected response success code: 204").size()).isOne();
    }

    @Test
    public void shouldMakeRetriesOnRequestFailure() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withFault(Fault.MALFORMED_RESPONSE_CHUNK)));
        Data expectedData = this.adjustDataWithCommandCounts(this.configuration.getTelemetryData());
        String expectedRequestBody = new Gson().toJson((Object)expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((int)3, (RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)expectedRequestBody, (JSONCompareMode)JSONCompareMode.LENIENT)));
    }

    @Test
    public void shouldSendTelemetryWhenDbMetricsDisabled() {
        boolean telemetryInitialized = true;
        StandaloneInMemProcessEngineConfiguration inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        inMemoryConfiguration.setInitializeTelemetry(telemetryInitialized).setTelemetryEndpoint(TELEMETRY_ENDPOINT).setMetricsEnabled(false).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.standaloneProcessEngine = inMemoryConfiguration.buildProcessEngine();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(204)));
        inMemoryConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendDataWithCamundaIntegration() {
        Data expectedData = this.createDataWithCamundaIntegration(this.configuration.getTelemetryData(), "wildfly-integration");
        Data givenData = this.createDataWithCamundaIntegration(this.configuration.getTelemetryData(), "wildfly-integration");
        this.managementService.toggleTelemetry(true);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), this.configuration.getTelemetryEndpoint(), 0, this.configuration.getTelemetryReportingPeriod(), givenData, this.configuration.getTelemetryHttpConnector(), this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout()).reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    protected ProcessEngineConfigurationImpl createEngineWithInitMessage(Boolean initTelemetry) {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setProcessEngineName("standalone").setTelemetryEndpoint(TELEMETRY_ENDPOINT).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        if (initTelemetry != null) {
            processEngineConfiguration.setInitializeTelemetry(initTelemetry.booleanValue());
        }
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
        return processEngineConfiguration;
    }

    protected Data createDataToSend() {
        Database database = new Database("mySpecialDb", "v.1.2.3");
        Jdk jdk = ParseUtil.parseJdkDetails();
        Internals internals = new Internals(database, new ApplicationServer("Apache Tomcat/10.0.1"), null, jdk);
        internals.setTelemetryEnabled(Boolean.valueOf(true));
        Map<String, Command> commands = this.getDefaultCommandCounts();
        internals.setCommands(commands);
        Map<String, Metric> metrics = this.getDefaultMetrics();
        internals.setMetrics(metrics);
        Product product = new Product("Runtime", "7.14.0", "special", internals);
        Data data = new Data("f5b19e2e-b49a-11ea-b3de-0242ac130004", product);
        return data;
    }

    protected Data createDataWithCamundaIntegration(Data telemetryData, String integrationString) {
        Internals internals = new Internals(null, null, null, null);
        Data data = new Data(telemetryData.getInstallation(), new Product("dummy", "dummy", "dummy", internals));
        HashSet<String> integration = new HashSet<String>();
        integration.add(integrationString);
        internals.setCamundaIntegration(integration);
        return data;
    }

    protected Data createInitialDataToSend(Data telemetryData, Boolean telemetryEnabled) {
        Data result = this.initData(telemetryData);
        Internals internals = new Internals();
        internals.setTelemetryEnabled(telemetryEnabled);
        result.getProduct().setInternals(internals);
        return result;
    }

    protected Data adjustDataWithAppServerInfo(Data telemetryData, String applicationServerVersion) {
        Data result = this.initData(telemetryData);
        Internals internals = result.getProduct().getInternals();
        internals.setApplicationServer(new ApplicationServer(applicationServerVersion));
        Map<String, Command> commands = this.getDefaultCommandCounts();
        internals.setCommands(commands);
        Map<String, Metric> metrics = this.getDefaultMetrics();
        result.getProduct().getInternals().setMetrics(metrics);
        return result;
    }

    protected Data adjustDataWithCommandCounts(Data telemetryData) {
        Data result = this.initData(telemetryData);
        Map commands = result.getProduct().getInternals().getCommands();
        commands.put("GetHistoryLevelCmd", new Command(1L));
        commands.put("GetLicenseKeyCmd", new Command(1L));
        result.getProduct().getInternals().setCommands(commands);
        return result;
    }

    protected Data adjustDataWithLicenseInfo(Data telemetryData, LicenseKeyData licenseKeyData) {
        Data result = this.initData(telemetryData);
        Internals internals = result.getProduct().getInternals();
        internals.setLicenseKey(licenseKeyData);
        return result;
    }

    protected Data adjustDataWithRawLicenseInfo(Data telemetryData, String licenseKeyRaw) {
        Data result = this.initData(telemetryData);
        Internals internals = result.getProduct().getInternals();
        internals.setLicenseKey(new LicenseKeyData(null, null, null, null, null, licenseKeyRaw));
        return result;
    }

    protected Map<String, Command> getDefaultCommandCounts() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("TelemetryConfigureCmd", new Command(1L));
        commands.put("IsTelemetryEnabledCmd", new Command(1L));
        return commands;
    }

    protected Map<String, Metric> getDefaultMetrics() {
        return this.assembleMetrics(0L, 0L, 0L, 0L, 0L);
    }

    protected Data adjustDataWithMetricCounts(Data telemetryData, long processCount, long decisionElementsCount, long decisionInstancesCount, long activityInstanceCount, long workerCount) {
        Data result = this.initData(telemetryData);
        Internals internals = result.getProduct().getInternals();
        Map<String, Metric> metrics = this.assembleMetrics(processCount, decisionElementsCount, decisionInstancesCount, activityInstanceCount, workerCount);
        internals.setMetrics(metrics);
        this.configuration.getTelemetryRegistry().getCommands().clear();
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("IsTelemetryEnabledCmd", new Command(1L));
        internals.setCommands(commands);
        return result;
    }

    protected Data initData(Data telemetryData) {
        Data data = new Data(telemetryData.getInstallation(), new Product(telemetryData.getProduct()));
        data.getProduct().getInternals().setTelemetryEnabled(Boolean.valueOf(true));
        return data;
    }

    protected Map<String, Metric> assembleMetrics(long processCount, long decisionElementsCount, long decisionInstancesCount, long activityInstanceCount, long workerCount) {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("root-process-instance-start", new Metric(processCount));
        metrics.put("executed-decision-elements", new Metric(decisionElementsCount));
        metrics.put("executed-decision-instances", new Metric(decisionInstancesCount));
        metrics.put("activity-instance-start", new Metric(activityInstanceCount));
        metrics.put("unique-task-workers", new Metric(workerCount));
        return metrics;
    }

    protected Date addHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, 1);
        Date newDate = calendar.getTime();
        return newDate;
    }

    protected BpmnModelInstance createProcessWithBusinessRuleTask(String processId, String decisionRef) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent().businessRuleTask("task").endEvent().done();
        BusinessRuleTask task = (BusinessRuleTask)modelInstance.getModelElementById("task");
        task.setCamundaDecisionRef(decisionRef);
        return modelInstance;
    }
}

