/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyBatchTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain defaultRuleChin = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected BatchMigrationHelper batchHelper = new BatchMigrationHelper(this.engineRule);
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ProcessDefinition tenant1Definition;
    protected ProcessDefinition tenant2Definition;
    protected ProcessDefinition sharedDefinition;

    @Before
    public void initServices() {
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Before
    public void deployProcesses() {
        this.sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.tenant1Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        this.tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_TWO, ProcessModels.ONE_TASK_PROCESS);
    }

    @After
    public void removeBatches() {
        this.batchHelper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testBatchTenantIdCase1() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.sharedDefinition, this.sharedDefinition);
        Assert.assertNull((Object)batch.getTenantId());
    }

    @Test
    public void testBatchTenantIdCase2() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant1Definition, this.sharedDefinition);
        Assert.assertEquals((Object)TENANT_ONE, (Object)batch.getTenantId());
    }

    @Test
    public void testBatchTenantIdCase3() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.sharedDefinition, this.tenant1Definition);
        Assert.assertNull((Object)batch.getTenantId());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricBatchTenantId() {
        this.batchHelper.migrateProcessInstanceAsync(this.tenant1Definition, this.tenant1Definition);
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        Assert.assertEquals((Object)TENANT_ONE, (Object)historicBatch.getTenantId());
    }

    @Test
    public void testBatchJobDefinitionsTenantId() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant1Definition, this.tenant1Definition);
        JobDefinition migrationJobDefinition = this.batchHelper.getExecutionJobDefinition(batch);
        Assert.assertEquals((Object)TENANT_ONE, (Object)migrationJobDefinition.getTenantId());
        JobDefinition monitorJobDefinition = this.batchHelper.getMonitorJobDefinition(batch);
        Assert.assertEquals((Object)TENANT_ONE, (Object)monitorJobDefinition.getTenantId());
        JobDefinition seedJobDefinition = this.batchHelper.getSeedJobDefinition(batch);
        Assert.assertEquals((Object)TENANT_ONE, (Object)seedJobDefinition.getTenantId());
    }

    @Test
    public void testBatchJobsTenantId() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant1Definition, this.tenant1Definition);
        Job seedJob = this.batchHelper.getSeedJob(batch);
        Assert.assertEquals((Object)TENANT_ONE, (Object)seedJob.getTenantId());
        this.batchHelper.completeSeedJobs(batch);
        List<Job> migrationJob = this.batchHelper.getExecutionJobs(batch);
        Assert.assertEquals((Object)TENANT_ONE, (Object)migrationJob.get(0).getTenantId());
        Job monitorJob = this.batchHelper.getMonitorJob(batch);
        Assert.assertEquals((Object)TENANT_ONE, (Object)monitorJob.getTenantId());
    }

    @Test
    public void testDeleteBatch() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant1Definition, this.tenant1Definition);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        this.managementService.deleteBatch(batch.getId(), true);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.managementService.createBatchQuery().count());
    }

    @Test
    public void testDeleteBatchFailsWithWrongTenant() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant2Definition, this.tenant2Definition);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        try {
            this.managementService.deleteBatch(batch.getId(), true);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot delete batch '" + batch.getId() + "' because it belongs to no authenticated tenant")));
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Test
    public void testSuspendBatch() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant1Definition, this.tenant1Definition);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        this.managementService.suspendBatchById(batch.getId());
        this.identityService.clearAuthentication();
        batch = (Batch)this.managementService.createBatchQuery().batchId(batch.getId()).singleResult();
        Assert.assertTrue((boolean)batch.isSuspended());
    }

    @Test
    public void testSuspendBatchFailsWithWrongTenant() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant2Definition, this.tenant2Definition);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        try {
            this.managementService.suspendBatchById(batch.getId());
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot suspend batch '" + batch.getId() + "' because it belongs to no authenticated tenant")));
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Test
    public void testActivateBatch() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant1Definition, this.tenant1Definition);
        this.managementService.suspendBatchById(batch.getId());
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        this.managementService.activateBatchById(batch.getId());
        this.identityService.clearAuthentication();
        batch = (Batch)this.managementService.createBatchQuery().batchId(batch.getId()).singleResult();
        Assert.assertFalse((boolean)batch.isSuspended());
    }

    @Test
    public void testActivateBatchFailsWithWrongTenant() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.tenant2Definition, this.tenant2Definition);
        this.managementService.suspendBatchById(batch.getId());
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        try {
            this.managementService.activateBatchById(batch.getId());
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot activate batch '" + batch.getId() + "' because it belongs to no authenticated tenant")));
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }
}

