/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyTaskServiceTest
extends PluggableProcessEngineTest {
    private static final String tenant1 = "the-tenant-1";
    private static final String tenant2 = "the-tenant-2";

    @Test
    public void testStandaloneTaskCreateWithTenantId() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)tenant1, (Object)task.getTenantId());
        this.deleteTasks(task);
    }

    @Test
    public void testStandaloneTaskCannotChangeTenantIdIfNull() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setTenantId(tenant1);
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-03072 Cannot change tenantId of Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    @Test
    public void testStandaloneTaskCannotChangeTenantId() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setTenantId(tenant2);
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-03072 Cannot change tenantId of Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    @Test
    public void testStandaloneTaskCannotSetDifferentTenantIdOnSubTask() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        Task subTask = this.taskService.newTask();
        subTask.setParentTaskId(task.getId());
        subTask.setTenantId(tenant2);
        try {
            this.taskService.saveTask(subTask);
            Assert.fail((String)"Exception expected.");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-03073 Cannot set different tenantId on subtask than on parent Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    @Test
    public void testStandaloneTaskCannotSetDifferentTenantIdOnSubTaskWithNull() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        Task subTask = this.taskService.newTask();
        subTask.setParentTaskId(task.getId());
        subTask.setTenantId(tenant1);
        try {
            this.taskService.saveTask(subTask);
            Assert.fail((String)"Exception expected.");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-03073 Cannot set different tenantId on subtask than on parent Task", e.getMessage());
        }
        this.deleteTasks(task);
    }

    @Test
    public void testStandaloneTaskPropagateTenantIdToSubTask() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        Task subTask = this.taskService.newTask();
        subTask.setParentTaskId(task.getId());
        this.taskService.saveTask(subTask);
        subTask = (Task)this.taskService.createTaskQuery().taskId(subTask.getId()).singleResult();
        Assert.assertEquals((Object)tenant1, (Object)subTask.getTenantId());
        this.deleteTasks(subTask, task);
    }

    @Test
    public void testStandaloneTaskPropagatesTenantIdToVariableInstance() {
        Task task = this.taskService.newTask();
        task.setTenantId(tenant1);
        this.taskService.saveTask(task);
        this.taskService.setVariable(task.getId(), "var", (Object)"test");
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenant1));
        this.deleteTasks(task);
    }

    @Test
    public void testGetIdentityLinkWithTenantIdForCandidateUsers() {
        BpmnModelInstance oneTaskProcess = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("task").camundaCandidateUsers("aUserId")).endEvent().done();
        this.testRule.deployForTenant("tenant", oneTaskProcess);
        ProcessInstance tenantProcessInstance = this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId("tenant").execute();
        Task tenantTask = (Task)this.taskService.createTaskQuery().processInstanceId(tenantProcessInstance.getId()).singleResult();
        List identityLinks = this.taskService.getIdentityLinksForTask(tenantTask.getId());
        Assert.assertEquals((long)identityLinks.size(), (long)1L);
        Assert.assertEquals((Object)((IdentityLink)identityLinks.get(0)).getTenantId(), (Object)"tenant");
    }

    @Test
    public void testGetIdentityLinkWithTenantIdForCandidateGroup() {
        BpmnModelInstance oneTaskProcess = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("task").camundaCandidateGroups("aGroupId")).endEvent().done();
        this.testRule.deployForTenant("tenant", oneTaskProcess);
        ProcessInstance tenantProcessInstance = this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId("tenant").execute();
        Task tenantTask = (Task)this.taskService.createTaskQuery().processInstanceId(tenantProcessInstance.getId()).singleResult();
        List identityLinks = this.taskService.getIdentityLinksForTask(tenantTask.getId());
        Assert.assertEquals((long)identityLinks.size(), (long)1L);
        Assert.assertEquals((Object)((IdentityLink)identityLinks.get(0)).getTenantId(), (Object)"tenant");
    }

    protected void deleteTasks(Task ... tasks) {
        for (Task task : tasks) {
            this.taskService.deleteTask(task.getId(), true);
        }
    }
}

