/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyDecisionRequirementsDefinitionQueryTest {
    protected static final String DECISION_REQUIREMENTS_DEFINITION_KEY = "score";
    protected static final String DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
    }

    @Test
    public void queryNoTenantIdSet() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void queryByTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByTenantIds() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void queryByDefinitionsWithoutTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void queryByKey() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByLatestNoTenantIdSet() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, DecisionRequirementsDefinition> definitionsForTenant = this.getDecisionRequirementsDefinitionsForTenant(query.list());
        Assert.assertThat((Object)definitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)definitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)definitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void queryByLatestWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionRequirementsDefinition DecisionRequirementsDefinition2 = (DecisionRequirementsDefinition)query.singleResult();
        Assert.assertThat((Object)DecisionRequirementsDefinition2.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)DecisionRequirementsDefinition2.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionRequirementsDefinition2 = (DecisionRequirementsDefinition)query.singleResult();
        Assert.assertThat((Object)DecisionRequirementsDefinition2.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)DecisionRequirementsDefinition2.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void queryByLatestWithTenantIds() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = (DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Map<String, DecisionRequirementsDefinition> definitionsForTenant = this.getDecisionRequirementsDefinitionsForTenant(query.list());
        Assert.assertThat((Object)definitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)definitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void queryByLatestWithoutTenantId() {
        this.testRule.deploy(DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionRequirementsDefinition DecisionRequirementsDefinition2 = (DecisionRequirementsDefinition)query.singleResult();
        Assert.assertThat((Object)DecisionRequirementsDefinition2.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)DecisionRequirementsDefinition2.getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void queryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, DecisionRequirementsDefinition> definitionsForTenant = this.getDecisionRequirementsDefinitionsForTenant(query.list());
        Assert.assertThat((Object)definitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)definitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)definitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void queryByNonExistingTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failQueryByTenantIdNull() {
        this.thrown.expect(NullValueException.class);
        this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{null});
    }

    @Test
    public void querySortingAsc() {
        List DecisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)DecisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    @Test
    public void querySortingDesc() {
        List DecisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)DecisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void queryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void queryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected Map<String, DecisionRequirementsDefinition> getDecisionRequirementsDefinitionsForTenant(List<DecisionRequirementsDefinition> definitions) {
        HashMap<String, DecisionRequirementsDefinition> definitionsForTenant = new HashMap<String, DecisionRequirementsDefinition>();
        for (DecisionRequirementsDefinition definition : definitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }
}

