/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyProcessDefinitionQueryTest
extends PluggableProcessEngineTest {
    protected static final String PROCESS_DEFINITION_KEY = "process";
    protected static final BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess((String)"process").done();
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deploy(emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_TWO, emptyProcess);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryByTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByTenantIds() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryByDefinitionsWithoutTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeProcessDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeProcessDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeProcessDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryByKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByLatestNoTenantIdSet() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, ProcessDefinition> processDefinitionsForTenant = this.getProcessDefinitionsForTenant(query.list());
        Assert.assertThat((Object)processDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)processDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)processDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryByLatestWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        ProcessDefinition processDefinition = (ProcessDefinition)query.singleResult();
        Assert.assertThat((Object)processDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)processDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        processDefinition = (ProcessDefinition)query.singleResult();
        Assert.assertThat((Object)processDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)processDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryByLatestWithTenantIds() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Map<String, ProcessDefinition> processDefinitionsForTenant = this.getProcessDefinitionsForTenant(query.list());
        Assert.assertThat((Object)processDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)processDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryByLatestWithoutTenantId() {
        this.testRule.deploy(emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        ProcessDefinition processDefinition = (ProcessDefinition)query.singleResult();
        Assert.assertThat((Object)processDefinition.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)processDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testQueryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.testRule.deploy(emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeProcessDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, ProcessDefinition> processDefinitionsForTenant = this.getProcessDefinitionsForTenant(query.list());
        Assert.assertThat((Object)processDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)processDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)processDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    @Test
    public void testQuerySortingDesc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    protected Map<String, ProcessDefinition> getProcessDefinitionsForTenant(List<ProcessDefinition> processDefinitions) {
        HashMap<String, ProcessDefinition> definitionsForTenant = new HashMap<String, ProcessDefinition>();
        for (ProcessDefinition definition : processDefinitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeProcessDefinitionsWithoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }
}

