/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SingleProcessInstanceModificationAsyncTest
extends PluggableProcessEngineTest {
    protected static final String PARALLEL_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";
    protected static final String ONE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml";
    protected static final String TRANSITION_LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.transitionListeners.bpmn20.xml";
    protected static final String TASK_LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.taskListeners.bpmn20.xml";
    protected static final String IO_MAPPING_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMapping.bpmn20.xml";
    protected static final String CALL_ACTIVITY_PARENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityParentProcess.bpmn";
    protected static final String CALL_ACTIVITY_CHILD_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityChildProcess.bpmn";

    @After
    public void tearDown() {
        List batches = this.managementService.createBatchQuery().list();
        for (Batch batch : batches) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.deleteJob(job.getId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testTheDeploymentIdIsSet() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processDefinitionId = processInstance.getProcessDefinitionId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        Job job = (Job)this.managementService.createJobQuery().jobDefinitionId(modificationBatch.getSeedJobDefinitionId()).singleResult();
        this.managementService.executeJob(job.getId());
        for (Job pending : this.managementService.createJobQuery().jobDefinitionId(modificationBatch.getBatchJobDefinitionId()).list()) {
            this.managementService.executeJob(pending.getId());
            Assert.assertEquals((Object)processDefinition.getDeploymentId(), (Object)pending.getDeploymentId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        this.completeTasksInOrder("task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationThatEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task2")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationWithWrongProcessInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            Batch modificationBatch = this.runtimeService.createProcessInstanceModification("foo").cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task2")).executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            this.testRule.assertProcessEnded(processInstance.getId());
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-13036"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance 'foo' cannot be modified"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeWithAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2", tree.getId()).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("someNonExistingActivity")).executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("element 'someNonExistingActivity' does not exist in process ", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testEndProcessInstanceIntermediately() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startAfterActivity("task1")).startBeforeActivity("task1")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task1").scope().done());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow4")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransitionWithAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow4", tree.getId()).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransitionInvalidTransitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        try {
            Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startTransition("invalidFlowId")).executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not suceed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start transition 'invalidFlowId'; Element 'invalidFlowId' does not exist in process '" + processInstance.getProcessDefinitionId() + "'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theStart")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task1").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task1");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterWithAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theStart", tree.getId()).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task1").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task1");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterActivityAmbiguousTransitions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        try {
            Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startAfterActivity("fork")).executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not suceed since 'fork' has more than one outgoing sequence flow");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("activity has more than one outgoing sequence flow", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterActivityNoOutgoingTransitions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        try {
            Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startAfterActivity("theEnd")).executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not suceed since 'theEnd' has no outgoing sequence flow");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("activity has no outgoing sequence flow to take", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startAfterActivity("someNonExistingActivity")).executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("Cannot perform instruction: Start after activity 'someNonExistingActivity'; Activity 'someNonExistingActivity' does not exist: activity is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testScopeTaskStartBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("theTask").scope().up().up().child(null).concurrent().noScope().child("theTask").scope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("theTask", "theTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testScopeTaskStartAfter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theTask")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").scope().done());
        Batch modificationBatch2 = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theStart")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch2);
        this.executeSeedAndBatchJobs(modificationBatch2);
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").activity("theTask").done());
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("theTask").scope().up().up().child(null).concurrent().noScope().child("theTask").scope().done());
        this.completeTasksInOrder("theTask", "theTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.taskListeners.bpmn20.xml"})
    @Test
    public void testSkipTaskListenerInvocation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess", "brum", Collections.singletonMap("listener", new RecorderTaskListener()));
        String processInstanceId = processInstance.getId();
        RecorderTaskListener.clear();
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("task")).executeAsync(true, false);
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        Assert.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
        ActivityInstance activityInstanceTree = this.runtimeService.getActivityInstance(processInstanceId);
        Batch batch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getChildInstanceForActivity(activityInstanceTree, "task").getId()).executeAsync(true, false);
        Assert.assertNotNull((Object)batch);
        this.executeSeedAndBatchJobs(batch);
        Assert.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMapping.bpmn20.xml"})
    @Test
    public void testSkipIoMappings() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).executeAsync(false, true);
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        Assert.assertNotNull((Object)task2Execution);
        Assert.assertNull((Object)this.runtimeService.getVariable(task2Execution.getId(), "inputMappingExecuted"));
        Batch modificationBatch2 = this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("task2").executeAsync(false, true);
        Assert.assertNotNull((Object)modificationBatch2);
        this.executeSeedAndBatchJobs(modificationBatch2);
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "outputMappingExecuted"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.transitionListeners.bpmn20.xml"})
    @Test
    public void testStartTransitionListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("transitionListenerProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startTransition("flow2")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        RecorderExecutionListener.RecordedEvent event = events.get(0);
        Assert.assertEquals((Object)"flow2", (Object)event.getTransitionId());
        RecorderExecutionListener.clear();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)instance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "task2", "task2");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.transitionListeners.bpmn20.xml"})
    @Test
    public void testStartAfterActivityListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("transitionListenerProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startTransition("flow2")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        RecorderExecutionListener.RecordedEvent event = events.get(0);
        Assert.assertEquals((Object)"flow2", (Object)event.getTransitionId());
        RecorderExecutionListener.clear();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)instance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "task2", "task2");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testCancellationAndStartBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task2")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        ActivityInstance activityInstanceTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstanceTree);
        Assert.assertEquals((Object)processInstanceId, (Object)activityInstanceTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(activityInstanceTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        this.completeTasksInOrder("task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testCancelNonExistingActivityInstance() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            Batch modificationBatch = this.runtimeService.createProcessInstanceModification(instance.getId()).cancelActivityInstance("nonExistingActivityInstance").executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Cancel activity instance 'nonExistingActivityInstance'; Activity instance 'nonExistingActivityInstance' does not exist", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testCancelNonExistingTranisitionInstance() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            Batch modificationBatch = this.runtimeService.createProcessInstanceModification(instance.getId()).cancelTransitionInstance("nonExistingActivityInstance").executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Cancel transition instance 'nonExistingActivityInstance'; Transition instance 'nonExistingActivityInstance' does not exist", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityParentProcess.bpmn", "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityChildProcess.bpmn"})
    @Test
    public void testCancelCallActivityInstance() {
        ProcessInstance parentprocess = this.runtimeService.startProcessInstanceByKey("parentprocess");
        ProcessInstance subProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").singleResult();
        ActivityInstance subProcessActivityInst = this.runtimeService.getActivityInstance(subProcess.getId());
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(subProcess.getId()).startBeforeActivity("childEnd", subProcess.getId()).cancelActivityInstance(this.getInstanceIdForActivity(subProcessActivityInst, "innerTask")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        this.executeSeedAndBatchJobs(modificationBatch);
        this.testRule.assertProcessEnded(parentprocess.getId());
    }

    @Test
    public void testModifyNullProcessInstance() {
        try {
            Batch modificationBatch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(null).startBeforeActivity("someActivity")).executeAsync();
            Assert.assertNotNull((Object)modificationBatch);
            this.executeSeedAndBatchJobs(modificationBatch);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("processInstanceId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testSetInvocationsPerBatchType() {
        this.processEngineConfiguration.getInvocationsPerBatchJobByBatchType().put("instance-modification", 42);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Batch batch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task2")).executeAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.processEngineConfiguration.setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    protected void executeSeedAndBatchJobs(Batch batch) {
        Job job = (Job)this.managementService.createJobQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).singleResult();
        this.managementService.executeJob(job.getId());
        for (Job pending : this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
            this.managementService.executeJob(pending.getId());
        }
    }

    protected String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

