/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationProcessInstanceTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testRule = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Test
    public void testMigrateWithIdVarargsArray() {
        ProcessDefinition sourceDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).execute();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionId(targetDefinition.getId()).count());
    }

    @Test
    public void testNullMigrationPlan() {
        try {
            this.runtimeService.newMigration(null).processInstanceIds(Collections.emptyList()).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"migration plan is null"));
        }
    }

    @Test
    public void testNullProcessInstanceIdsList() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds((List)null).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is empty"));
        }
    }

    @Test
    public void testProcessInstanceIdsListWithNullValue() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList("foo", null, "bar")).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids contains null value"));
        }
    }

    @Test
    public void testNullProcessInstanceIdsArray() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds((String[])null).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is empty"));
        }
    }

    @Test
    public void testProcessInstanceIdsArrayWithNullValue() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{"foo", null, "bar"}).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids contains null value"));
        }
    }

    @Test
    public void testEmptyProcessInstanceIdsList() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.emptyList()).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is empty"));
        }
    }

    @Test
    public void testEmptyProcessInstanceIdsArray() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[0]).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is empty"));
        }
    }

    @Test
    public void testNotMigrateProcessInstanceOfWrongProcessDefinition() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition wrongProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(wrongProcessDefinition.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(processInstance.getId())).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-23002"));
        }
    }

    @Test
    public void testNotMigrateUnknownProcessInstance() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList("unknown")).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-23003"));
        }
    }

    @Test
    public void testNotMigrateNullProcessInstance() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(null)).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids contains null value"));
        }
    }

    @Test
    public void testMigrateProcessInstanceQuery() {
        int processInstanceCount = 10;
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        for (int i = 0; i < processInstanceCount; ++i) {
            this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        }
        ProcessInstanceQuery sourceProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        ProcessInstanceQuery targetProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(targetProcessDefinition.getId());
        Assert.assertEquals((long)processInstanceCount, (long)sourceProcessInstanceQuery.count());
        Assert.assertEquals((long)0L, (long)targetProcessInstanceQuery.count());
        this.runtimeService.newMigration(migrationPlan).processInstanceQuery(sourceProcessInstanceQuery).execute();
        Assert.assertEquals((long)0L, (long)sourceProcessInstanceQuery.count());
        Assert.assertEquals((long)processInstanceCount, (long)targetProcessInstanceQuery.count());
    }

    @Test
    public void testNullProcessInstanceQuery() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceQuery(null).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is empty"));
        }
    }

    @Test
    public void testEmptyProcessInstanceQuery() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstanceQuery emptyProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)emptyProcessInstanceQuery.count());
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceQuery(emptyProcessInstanceQuery).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"process instance ids is empty"));
        }
    }

    @Test
    public void testProcessInstanceQueryOfWrongProcessDefinition() {
        ProcessDefinition testProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition wrongProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        this.runtimeService.startProcessInstanceById(wrongProcessDefinition.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstanceQuery wrongProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(wrongProcessDefinition.getId());
        Assert.assertEquals((long)1L, (long)wrongProcessInstanceQuery.count());
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceQuery(wrongProcessInstanceQuery).execute();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-23002"));
        }
    }

    @Test
    public void testProcessInstanceIdsAndQuery() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ProcessInstanceQuery sourceProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId());
        ProcessInstanceQuery targetProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(targetProcessDefinition.getId());
        Assert.assertEquals((long)0L, (long)targetProcessInstanceQuery.count());
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(processInstance1.getId())).processInstanceQuery(sourceProcessInstanceQuery).execute();
        Assert.assertEquals((long)2L, (long)targetProcessInstanceQuery.count());
    }

    @Test
    public void testOverlappingProcessInstanceIdsAndQuery() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ProcessInstanceQuery sourceProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        ProcessInstanceQuery targetProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(targetProcessDefinition.getId());
        Assert.assertEquals((long)0L, (long)targetProcessInstanceQuery.count());
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).processInstanceQuery(sourceProcessInstanceQuery).execute();
        Assert.assertEquals((long)2L, (long)targetProcessInstanceQuery.count());
    }
}

