/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.deployment;

import java.io.InputStream;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.DeploymentHandlerFactory;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.deployment.VersionedDeploymentHandlerFactory;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BpmnDeploymentTest
extends PluggableProcessEngineTest {
    DeploymentHandlerFactory defaultDeploymentHandlerFactory;
    DeploymentHandlerFactory customDeploymentHandlerFactory;

    @Before
    public void setUp() throws Exception {
        this.defaultDeploymentHandlerFactory = this.processEngineConfiguration.getDeploymentHandlerFactory();
        this.customDeploymentHandlerFactory = new VersionedDeploymentHandlerFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.defaultDeploymentHandlerFactory);
    }

    @Deployment
    @Test
    public void testGetBpmnXmlFileThroughService() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assert.assertEquals((long)1L, (long)deploymentResources.size());
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        Assert.assertEquals((Object)bpmnResourceName, deploymentResources.get(0));
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertEquals((Object)bpmnResourceName, (Object)processDefinition.getResourceName());
        Assert.assertNull((Object)processDefinition.getDiagramResourceName());
        Assert.assertFalse((boolean)processDefinition.hasStartFormKey());
        ReadOnlyProcessDefinition readOnlyProcessDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinition.getId());
        Assert.assertNull((Object)readOnlyProcessDefinition.getDiagramResourceName());
        InputStream deploymentInputStream = this.repositoryService.getResourceAsStream(deploymentId, bpmnResourceName);
        String contentFromDeployment = this.readInputStreamToString(deploymentInputStream);
        Assert.assertTrue((contentFromDeployment.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)contentFromDeployment.contains("process id=\"emptyProcess\""));
        InputStream fileInputStream = ReflectUtil.getResourceAsStream((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml");
        String contentFromFile = this.readInputStreamToString(fileInputStream);
        Assert.assertEquals((Object)contentFromFile, (Object)contentFromDeployment);
    }

    private String readInputStreamToString(InputStream inputStream) {
        byte[] bytes = IoUtil.readInputStream((InputStream)inputStream, (String)"input stream");
        return new String(bytes);
    }

    public void FAILING_testViolateProcessDefinitionIdMaximumLength() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/deployment/processWithLongId.bpmn20.xml").deploy();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("id can be maximum 64 characters", e.getMessage());
        }
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }

    @Test
    public void testDeploySameFileTwice() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).name("twice").deploy();
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assert.assertEquals((long)1L, (long)deploymentResources.size());
        Assert.assertEquals((Object)bpmnResourceName, deploymentResources.get(0));
        this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).name("twice").deploy();
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assert.assertEquals((long)1L, (long)deploymentList.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @Test
    public void testDuplicateFilteringDefaultBehavior() {
        BpmnModelInstance oldModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("3")).done();
        BpmnModelInstance newModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("1")).done();
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model", oldModel).name("defaultDeploymentHandling"));
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model", newModel).name("defaultDeploymentHandling"));
        long deploymentCount = this.repositoryService.createDeploymentQuery().count();
        Assert.assertEquals((long)2L, (long)deploymentCount);
    }

    @Test
    public void testDuplicateFilteringCustomBehavior() {
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.customDeploymentHandlerFactory);
        BpmnModelInstance oldModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("1")).done();
        BpmnModelInstance newModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("2")).done();
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model.bpmn", oldModel).name("customDeploymentHandling"));
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model.bpmn", newModel).name("customDeploymentHandling"));
        org.camunda.bpm.engine.repository.Deployment deployment3 = this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model.bpmn", oldModel).name("customDeploymentHandling").deploy();
        long deploymentCount = this.repositoryService.createDeploymentQuery().count();
        Assert.assertEquals((long)2L, (long)deploymentCount);
        Assert.assertEquals((Object)deployment1.getId(), (Object)deployment3.getId());
    }

    @Test
    public void testPartialChangesDeployAll() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        org.camunda.bpm.engine.repository.Deployment deployment1 = this.repositoryService.createDeployment().enableDuplicateFiltering().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).name("twice").deploy();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deployment1.getId());
        Assert.assertEquals((long)2L, (long)deploymentResources.size());
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment2 = this.repositoryService.createDeployment().enableDuplicateFiltering().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).name("twice").deploy();
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assert.assertEquals((long)2L, (long)deploymentList.size());
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count());
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count());
        this.repositoryService.deleteDeployment(deployment1.getId());
        this.repositoryService.deleteDeployment(deployment2.getId());
    }

    @Test
    public void testPartialChangesDeployChangedOnly() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        org.camunda.bpm.engine.repository.Deployment deployment1 = this.repositoryService.createDeployment().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).name("thrice").deploy();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deployment1.getId());
        Assert.assertEquals((long)2L, (long)deploymentResources.size());
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment2 = this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).name("thrice").deploy();
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assert.assertEquals((long)2L, (long)deploymentList.size());
        ProcessDefinition process1Definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
        Assert.assertNotNull((Object)process1Definition);
        Assert.assertEquals((long)1L, (long)process1Definition.getVersion());
        Assert.assertEquals((Object)deployment1.getId(), (Object)process1Definition.getDeploymentId());
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count());
        BpmnModelInstance anotherChangedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment3 = this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", anotherChangedModel2).name("thrice").deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count());
        Assert.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count());
        this.repositoryService.deleteDeployment(deployment1.getId());
        this.repositoryService.deleteDeployment(deployment2.getId());
        this.repositoryService.deleteDeployment(deployment3.getId());
    }

    @Test
    public void testPartialChangesRedeployOldVersion() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        org.camunda.bpm.engine.repository.Deployment deployment1 = this.repositoryService.createDeployment().addModelInstance("process1.bpmn20.xml", model1).name("deployment").deploy();
        BpmnModelInstance changedModel1 = Bpmn.createExecutableProcess((String)"process1").startEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment2 = this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", changedModel1).name("deployment").deploy();
        org.camunda.bpm.engine.repository.Deployment deployment3 = this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", model1).name("deployment").deploy();
        Assert.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count());
        this.repositoryService.deleteDeployment(deployment1.getId());
        this.repositoryService.deleteDeployment(deployment2.getId());
        this.repositoryService.deleteDeployment(deployment3.getId());
    }

    @Test
    public void testDeployTwoProcessesWithDuplicateIdAtTheSameTime() {
        try {
            String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
            String bpmnResourceName2 = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService2.bpmn20.xml";
            this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).addClasspathResource(bpmnResourceName2).name("duplicateAtTheSameTime").deploy();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }

    @Test
    public void testDeployDifferentFiles() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName).name("twice").deploy();
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assert.assertEquals((long)1L, (long)deploymentResources.size());
        Assert.assertEquals((Object)bpmnResourceName, deploymentResources.get(0));
        bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml";
        this.repositoryService.createDeployment().enableDuplicateFiltering().addClasspathResource(bpmnResourceName).name("twice").deploy();
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assert.assertEquals((long)2L, (long)deploymentList.size());
        this.deleteDeployments(deploymentList);
    }

    @Test
    public void testDiagramCreationDisabled() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseDiagramInterchangeElements.bpmn20.xml").deploy();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey("myProcess");
            }
        });
        Assert.assertNotNull((Object)processDefinitionEntity);
        Assert.assertEquals((long)7L, (long)processDefinitionEntity.getActivities().size());
        List resourceNames = this.repositoryService.getDeploymentResourceNames(processDefinitionEntity.getDeploymentId());
        Assert.assertEquals((long)1L, (long)resourceNames.size());
        this.repositoryService.deleteDeployment(((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg"})
    @Test
    public void testProcessDiagramResource() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml", (Object)processDefinition.getResourceName());
        Assert.assertTrue((boolean)processDefinition.hasStartFormKey());
        String diagramResourceName = processDefinition.getDiagramResourceName();
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg", (Object)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg");
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        Assert.assertEquals((long)33343L, (long)diagramBytes.length);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.a.jpg", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.b.jpg", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.c.jpg"})
    @Test
    public void testMultipleDiagramResourcesProvided() {
        ProcessDefinition processA = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("a").singleResult();
        ProcessDefinition processB = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("b").singleResult();
        ProcessDefinition processC = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("c").singleResult();
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.a.jpg", (Object)processA.getDiagramResourceName());
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.b.jpg", (Object)processB.getDiagramResourceName());
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.c.jpg", (Object)processC.getDiagramResourceName());
    }

    @Deployment
    @Test
    public void testProcessDefinitionDescription() {
        String id = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ReadOnlyProcessDefinition processDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(id);
        Assert.assertEquals((Object)"This is really good process documentation!", (Object)processDefinition.getDescription());
    }

    @Test
    public void testDeployInvalidExpression() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testInvalidExpression.bpmn20.xml").deploy();
            Assert.fail((String)"Expected exception when deploying process with invalid expression.");
        }
        catch (ProcessEngineException expected) {
            Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
            this.testRule.assertTextPresent("ENGINE-01009 Error while parsing process", expected.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml"})
    @Test
    public void testDeploymentIdOfResource() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)deploymentId, (Object)resource.getDeploymentId());
    }

    private void deleteDeployments(List<org.camunda.bpm.engine.repository.Deployment> deploymentList) {
        for (org.camunda.bpm.engine.repository.Deployment deployment : deploymentList) {
            this.repositoryService.deleteDeployment(deployment.getId());
        }
    }

    @Test
    public void testDeployBpmnModelInstance() throws Exception {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"foo").startEvent().userTask().endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.bpmn", modelInstance));
        Assert.assertNotNull((Object)this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceName("foo.bpmn").singleResult());
    }

    @Test
    public void testDeployAndGetProcessDefinition() throws Exception {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"foo").startEvent().userTask().endEvent().done();
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.bpmn", modelInstance));
        List deployedProcessDefinitions = deployment.getDeployedProcessDefinitions();
        Assert.assertEquals((long)1L, (long)deployedProcessDefinitions.size());
        Assert.assertNull((Object)deployment.getDeployedCaseDefinitions());
        Assert.assertNull((Object)deployment.getDeployedDecisionDefinitions());
        Assert.assertNull((Object)deployment.getDeployedDecisionRequirementsDefinitions());
        ProcessDefinition persistedProcDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceName("foo.bpmn").singleResult();
        Assert.assertEquals((Object)persistedProcDef.getId(), (Object)((ProcessDefinition)deployedProcessDefinitions.get(0)).getId());
    }

    @Test
    public void testDeployNonExecutableProcess() throws Exception {
        BpmnModelInstance modelInstance = Bpmn.createProcess((String)"foo").startEvent().userTask().endEvent().done();
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.bpmn", modelInstance));
        Assert.assertNull((Object)deployment.getDeployedProcessDefinitions());
        Assert.assertNull((Object)this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceName("foo.bpmn").singleResult());
    }
}

