/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.scripting;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.script.ScriptEngine;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.SourceExecutableScript;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.engine.impl.scripting.env.ScriptEnvResolver;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnvScriptCachingTest
extends PluggableProcessEngineTest {
    protected static final String PROCESS_PATH = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String SCRIPT_LANGUAGE = "groovy";
    protected static final String SCRIPT = "println 'hello world'";
    protected static final String ENV_SCRIPT = "println 'hello world from env script'";
    protected static final ScriptEnvResolver RESOLVER = new ScriptEnvResolver(){

        public String[] resolve(String language) {
            return new String[]{EnvScriptCachingTest.ENV_SCRIPT};
        }
    };
    protected ScriptFactory scriptFactory;

    @Before
    public void setUp() throws Exception {
        this.scriptFactory = this.processEngineConfiguration.getScriptFactory();
        this.processEngineConfiguration.getEnvScriptResolvers().add(RESOLVER);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.getEnvScriptResolvers().remove(RESOLVER);
    }

    @Test
    public void testEnabledPaEnvScriptCaching() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        this.executeScript((ProcessApplicationInterface)processApplication);
        Map environmentScripts = processApplication.getEnvironmentScripts();
        Assert.assertNotNull((Object)environmentScripts);
        List groovyEnvScripts = (List)environmentScripts.get(SCRIPT_LANGUAGE);
        Assert.assertNotNull((Object)groovyEnvScripts);
        Assert.assertFalse((boolean)groovyEnvScripts.isEmpty());
        Assert.assertEquals((long)this.processEngineConfiguration.getEnvScriptResolvers().size(), (long)groovyEnvScripts.size());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testDisabledPaEnvScriptCaching() {
        this.processEngineConfiguration.setEnableFetchScriptEngineFromProcessApplication(false);
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(processApplication.getReference()).addClasspathResource(PROCESS_PATH).deploy();
        this.executeScript((ProcessApplicationInterface)processApplication);
        Map environmentScripts = processApplication.getEnvironmentScripts();
        Assert.assertNotNull((Object)environmentScripts);
        Assert.assertNull(environmentScripts.get(SCRIPT_LANGUAGE));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.processEngineConfiguration.setEnableFetchScriptEngineFromProcessApplication(true);
    }

    protected SourceExecutableScript createScript(String language, String source) {
        return (SourceExecutableScript)this.scriptFactory.createScriptFromSource(language, source);
    }

    protected void executeScript(final ProcessApplicationInterface processApplication) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                return (Void)Context.executeWithinProcessApplication((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ScriptingEngines scriptingEngines = EnvScriptCachingTest.this.processEngineConfiguration.getScriptingEngines();
                        ScriptEngine scriptEngine = scriptingEngines.getScriptEngineForLanguage(EnvScriptCachingTest.SCRIPT_LANGUAGE);
                        SourceExecutableScript script = EnvScriptCachingTest.this.createScript(EnvScriptCachingTest.SCRIPT_LANGUAGE, EnvScriptCachingTest.SCRIPT);
                        ScriptingEnvironment scriptingEnvironment = EnvScriptCachingTest.this.processEngineConfiguration.getScriptingEnvironment();
                        scriptingEnvironment.execute((ExecutableScript)script, null, null, scriptEngine);
                        return null;
                    }
                }, (ProcessApplicationReference)processApplication.getReference());
            }
        });
    }
}

