/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.camunda.bpm.container.impl.jmx.deployment.MockInitialContextRule;
import org.camunda.bpm.container.impl.tomcat.deployment.TomcatParseBpmPlatformXmlStep;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.mock.jndi.SimpleNamingContext;

public class BpmPlatformXmlLocationTest {
    private static final String BPM_PLATFORM_XML_LOCATION_PARENT_DIR = BpmPlatformXmlLocationTest.getBpmPlatformXmlLocationParentDir();
    private static final String BPM_PLATFORM_XML_LOCATION_ABSOLUTE_DIR = BPM_PLATFORM_XML_LOCATION_PARENT_DIR + File.separator + "conf";
    private static final String BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION = BPM_PLATFORM_XML_LOCATION_ABSOLUTE_DIR + File.separator + "bpm-platform.xml";
    private static final String BPM_PLATFORM_XML_LOCATION_RELATIVE_PATH = "home/hawky4s/.camunda";
    private static final String BPM_PLATFORM_XML_LOCATION_VALID_PATH_UNIX = "/home/hawky4s/.camunda";
    private static final String BPM_PLATFORM_XML_LOCATION_VALID_PATH_WINDOWS = "C:\\users\\hawky4s\\.camunda";
    private static final String BPM_PLATFORM_XML_LOCATION_FILE_INVALID_PATH_UNIX = "C:" + File.separator + "bpm-platform.xml";
    private static final String BPM_PLATFORM_XML_LOCATION_FILE_INVALID_PATH_WINDOWS = "C://users//hawky4s//.camunda//bpm-platform.xml";
    private static final String BPM_PLATFORM_XML_LOCATION_URL_HTTP_PROTOCOL = "http://localhost:8080/camunda/bpm-platform.xml";
    private static final String BPM_PLATFORM_XML_LOCATION_URL_HTTPS_PROTOCOL = "https://localhost:8080/camunda/bpm-platform.xml";
    @Rule
    public MockInitialContextRule initialContextRule = new MockInitialContextRule((Context)new SimpleNamingContext());

    @Test
    public void checkValidBpmPlatformXmlResourceLocationForUrl() throws NamingException, MalformedURLException {
        TomcatParseBpmPlatformXmlStep tomcatParseBpmPlatformXmlStep = new TomcatParseBpmPlatformXmlStep();
        Assert.assertNull((Object)tomcatParseBpmPlatformXmlStep.checkValidUrlLocation(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION));
        Assert.assertNull((Object)tomcatParseBpmPlatformXmlStep.checkValidUrlLocation(BPM_PLATFORM_XML_LOCATION_FILE_INVALID_PATH_WINDOWS));
        Assert.assertNull((Object)tomcatParseBpmPlatformXmlStep.checkValidUrlLocation(BPM_PLATFORM_XML_LOCATION_FILE_INVALID_PATH_UNIX));
        Assert.assertNull((Object)tomcatParseBpmPlatformXmlStep.checkValidUrlLocation(BPM_PLATFORM_XML_LOCATION_VALID_PATH_WINDOWS));
        Assert.assertNull((Object)tomcatParseBpmPlatformXmlStep.checkValidUrlLocation(BPM_PLATFORM_XML_LOCATION_VALID_PATH_UNIX));
        URL httpUrl = tomcatParseBpmPlatformXmlStep.checkValidUrlLocation(BPM_PLATFORM_XML_LOCATION_URL_HTTP_PROTOCOL);
        Assert.assertEquals((Object)BPM_PLATFORM_XML_LOCATION_URL_HTTP_PROTOCOL, (Object)httpUrl.toString());
        URL httpsUrl = tomcatParseBpmPlatformXmlStep.checkValidUrlLocation(BPM_PLATFORM_XML_LOCATION_URL_HTTPS_PROTOCOL);
        Assert.assertEquals((Object)BPM_PLATFORM_XML_LOCATION_URL_HTTPS_PROTOCOL, (Object)httpsUrl.toString());
    }

    @Test
    public void checkValidBpmPlatformXmlResourceLocationForFile() throws NamingException, MalformedURLException {
        TomcatParseBpmPlatformXmlStep tomcatParseBpmPlatformXmlStep = new TomcatParseBpmPlatformXmlStep();
        URL url = tomcatParseBpmPlatformXmlStep.checkValidFileLocation(BPM_PLATFORM_XML_LOCATION_RELATIVE_PATH);
        Assert.assertNull((String)"Relative path is invalid.", (Object)url);
        url = tomcatParseBpmPlatformXmlStep.checkValidFileLocation(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION);
        Assert.assertEquals((Object)new File(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION).toURI().toURL(), (Object)url);
        url = tomcatParseBpmPlatformXmlStep.checkValidFileLocation(BPM_PLATFORM_XML_LOCATION_FILE_INVALID_PATH_WINDOWS);
        Assert.assertNull((String)"Path is invalid.", (Object)url);
        Assert.assertNull((Object)tomcatParseBpmPlatformXmlStep.checkValidFileLocation(BPM_PLATFORM_XML_LOCATION_URL_HTTP_PROTOCOL));
        Assert.assertNull((Object)tomcatParseBpmPlatformXmlStep.checkValidFileLocation(BPM_PLATFORM_XML_LOCATION_URL_HTTPS_PROTOCOL));
    }

    @Test
    public void checkUrlAutoCompletion() throws NamingException, MalformedURLException {
        TomcatParseBpmPlatformXmlStep tomcatParseBpmPlatformXmlStep = new TomcatParseBpmPlatformXmlStep();
        String correctedUrl = tomcatParseBpmPlatformXmlStep.autoCompleteUrl(BPM_PLATFORM_XML_LOCATION_VALID_PATH_UNIX);
        Assert.assertEquals((Object)"/home/hawky4s/.camunda/bpm-platform.xml", (Object)correctedUrl);
        correctedUrl = tomcatParseBpmPlatformXmlStep.autoCompleteUrl("/home/hawky4s/.camunda/");
        Assert.assertEquals((Object)"/home/hawky4s/.camunda/bpm-platform.xml", (Object)correctedUrl);
        correctedUrl = tomcatParseBpmPlatformXmlStep.autoCompleteUrl(BPM_PLATFORM_XML_LOCATION_VALID_PATH_WINDOWS);
        Assert.assertEquals((Object)"C:\\users\\hawky4s\\.camunda\\bpm-platform.xml", (Object)correctedUrl);
    }

    @Test
    public void checkValidBpmPlatformXmlResourceLocation() throws NamingException, MalformedURLException {
        URL url = new TomcatParseBpmPlatformXmlStep().checkValidBpmPlatformXmlResourceLocation(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION);
        Assert.assertEquals((Object)new File(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION).toURI().toURL(), (Object)url);
    }

    @Test
    public void getBpmPlatformXmlLocationFromJndi() throws NamingException, MalformedURLException {
        InitialContext context = new InitialContext();
        context.bind("java:comp/env/bpm-platform-xml", (Object)BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION);
        URL url = new TomcatParseBpmPlatformXmlStep().lookupBpmPlatformXmlLocationFromJndi();
        Assert.assertEquals((Object)new File(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION).toURI().toURL(), (Object)url);
    }

    @Test
    public void bpmPlatformXmlLocationNotRegisteredInJndi() throws NamingException {
        URL url = new TomcatParseBpmPlatformXmlStep().lookupBpmPlatformXmlLocationFromJndi();
        Assert.assertNull((Object)url);
    }

    @Test
    public void getBpmPlatformXmlFromEnvironmentVariableAsUrlLocation() {
        try {
            System.setProperty("bpm.platform.xml", BPM_PLATFORM_XML_LOCATION_URL_HTTP_PROTOCOL);
            URL url = new TomcatParseBpmPlatformXmlStep().lookupBpmPlatformXmlLocationFromEnvironmentVariable();
            Assert.assertEquals((Object)BPM_PLATFORM_XML_LOCATION_URL_HTTP_PROTOCOL, (Object)url.toString());
        }
        finally {
            System.clearProperty("bpm.platform.xml");
        }
    }

    @Test
    public void getBpmPlatformXmlFromSystemPropertyAsFileLocation() throws MalformedURLException {
        try {
            System.setProperty("bpm.platform.xml", BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION);
            URL url = new TomcatParseBpmPlatformXmlStep().lookupBpmPlatformXmlLocationFromEnvironmentVariable();
            Assert.assertEquals((Object)new File(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION).toURI().toURL(), (Object)url);
        }
        finally {
            System.clearProperty("bpm.platform.xml");
        }
    }

    @Test
    public void getBpmPlatformXmlFromClasspath() {
        String classPathResourceLocation = BpmPlatformXmlLocationTest.class.getPackage().getName().replace(".", "/") + "/conf/" + "bpm-platform.xml";
        URL url = new TomcatParseBpmPlatformXmlStep().lookupBpmPlatformXmlFromClassPath(classPathResourceLocation);
        Assert.assertNotNull((String)"Url should point to a bpm-platform.xml file.", (Object)url);
    }

    @Test
    public void getBpmPlatformXmlFromCatalinaConfDirectory() throws MalformedURLException {
        System.setProperty("catalina.home", BPM_PLATFORM_XML_LOCATION_PARENT_DIR);
        try {
            URL url = new TomcatParseBpmPlatformXmlStep().lookupBpmPlatformXmlFromCatalinaConfDirectory();
            Assert.assertEquals((Object)new File(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION).toURI().toURL(), (Object)url);
        }
        finally {
            System.clearProperty("catalina.home");
        }
    }

    @Test
    public void lookupBpmPlatformXml() throws NamingException, MalformedURLException {
        InitialContext context = new InitialContext();
        context.bind("java:comp/env/bpm-platform-xml", (Object)BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION);
        URL url = new TomcatParseBpmPlatformXmlStep().lookupBpmPlatformXml();
        Assert.assertEquals((Object)new File(BPM_PLATFORM_XML_FILE_ABSOLUTE_LOCATION).toURI().toURL(), (Object)url);
    }

    private static String getBpmPlatformXmlLocationParentDir() {
        String baseDir = BpmPlatformXmlLocationTest.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        try {
            baseDir = URLDecoder.decode(baseDir, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return baseDir + BpmPlatformXmlLocationTest.class.getPackage().getName().replace(".", File.separator);
    }
}

