/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.parser;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.container.impl.metadata.BpmPlatformXmlParser;
import org.camunda.bpm.container.impl.metadata.spi.BpmPlatformXml;
import org.camunda.bpm.container.impl.metadata.spi.JobAcquisitionXml;
import org.camunda.bpm.container.impl.metadata.spi.JobExecutorXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEnginePluginXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BpmPlatformXmlParserTest {
    private BpmPlatformXmlParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new BpmPlatformXmlParser();
    }

    protected URL getStreamUrl(String filename) {
        return BpmPlatformXmlParserTest.class.getResource(filename);
    }

    @Test
    public void testParseBpmPlatformXmlNoEngine() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_no_engine.xml")).execute().getBpmPlatformXml();
        Assert.assertNotNull((Object)bpmPlatformXml);
        Assert.assertNotNull((Object)bpmPlatformXml.getJobExecutor());
        Assert.assertEquals((long)0L, (long)bpmPlatformXml.getProcessEngines().size());
        JobExecutorXml jobExecutorXml = bpmPlatformXml.getJobExecutor();
        Assert.assertEquals((long)1L, (long)jobExecutorXml.getJobAcquisitions().size());
        JobAcquisitionXml jobAcquisitionXml = (JobAcquisitionXml)jobExecutorXml.getJobAcquisitions().get(0);
        Assert.assertEquals((Object)"default", (Object)jobAcquisitionXml.getName());
        Assert.assertEquals((Object)"org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor", (Object)jobAcquisitionXml.getJobExecutorClassName());
        Assert.assertEquals((long)2L, (long)jobAcquisitionXml.getProperties().size());
    }

    @Test
    public void testParseBpmPlatformXmlOneEngine() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_one_engine.xml")).execute().getBpmPlatformXml();
        Assert.assertNotNull((Object)bpmPlatformXml);
        Assert.assertNotNull((Object)bpmPlatformXml.getJobExecutor());
        Assert.assertEquals((long)1L, (long)bpmPlatformXml.getProcessEngines().size());
        JobExecutorXml jobExecutorXml = bpmPlatformXml.getJobExecutor();
        Assert.assertEquals((long)1L, (long)jobExecutorXml.getJobAcquisitions().size());
        Assert.assertThat((Object)jobExecutorXml.getProperties().size(), (Matcher)CoreMatchers.is((Object)2));
        JobAcquisitionXml jobAcquisitionXml = (JobAcquisitionXml)jobExecutorXml.getJobAcquisitions().get(0);
        Assert.assertEquals((Object)"default", (Object)jobAcquisitionXml.getName());
        Assert.assertEquals((Object)"org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor", (Object)jobAcquisitionXml.getJobExecutorClassName());
        Assert.assertEquals((long)2L, (long)jobAcquisitionXml.getProperties().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)bpmPlatformXml.getProcessEngines().get(0);
        Assert.assertEquals((Object)"engine1", (Object)engineXml.getName());
        Assert.assertEquals((Object)"default", (Object)engineXml.getJobAcquisitionName());
        Map properties = engineXml.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((long)0L, (long)properties.size());
        List plugins = engineXml.getPlugins();
        Assert.assertNotNull((Object)plugins);
        Assert.assertEquals((long)0L, (long)plugins.size());
    }

    @Test
    public void testParseBpmPlatformXmlEnginePlugin() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_engine_plugin.xml")).execute().getBpmPlatformXml();
        Assert.assertNotNull((Object)bpmPlatformXml);
        Assert.assertEquals((long)1L, (long)bpmPlatformXml.getProcessEngines().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)bpmPlatformXml.getProcessEngines().get(0);
        Assert.assertEquals((Object)"engine1", (Object)engineXml.getName());
        Assert.assertEquals((Object)"default", (Object)engineXml.getJobAcquisitionName());
        List plugins = engineXml.getPlugins();
        Assert.assertEquals((long)1L, (long)plugins.size());
        ProcessEnginePluginXml plugin1 = (ProcessEnginePluginXml)plugins.get(0);
        Assert.assertNotNull((Object)plugin1);
        Assert.assertEquals((Object)"org.camunda.bpm.MyAwesomePlugin", (Object)plugin1.getPluginClass());
        Map properties = plugin1.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((long)2L, (long)properties.size());
        String val1 = (String)properties.get("prop1");
        Assert.assertNotNull((Object)val1);
        Assert.assertEquals((Object)"val1", (Object)val1);
        String val2 = (String)properties.get("prop2");
        Assert.assertNotNull((Object)val2);
        Assert.assertEquals((Object)"val2", (Object)val2);
    }

    @Test
    public void testParseBpmPlatformXmlMultipleEnginePlugins() {
        BpmPlatformXml bpmPlatformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_multiple_engine_plugins.xml")).execute().getBpmPlatformXml();
        Assert.assertNotNull((Object)bpmPlatformXml);
        Assert.assertEquals((long)1L, (long)bpmPlatformXml.getProcessEngines().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)bpmPlatformXml.getProcessEngines().get(0);
        Assert.assertEquals((Object)"engine1", (Object)engineXml.getName());
        Assert.assertEquals((Object)"default", (Object)engineXml.getJobAcquisitionName());
        List plugins = engineXml.getPlugins();
        Assert.assertEquals((long)2L, (long)plugins.size());
    }

    @Test
    public void testParseProcessesXmlAntStyleProperties() {
        BpmPlatformXml platformXml = this.parser.createParse().sourceUrl(this.getStreamUrl("bpmplatform_xml_ant_style_properties.xml")).execute().getBpmPlatformXml();
        Assert.assertNotNull((Object)platformXml);
        ProcessEngineXml engineXml = (ProcessEngineXml)platformXml.getProcessEngines().get(0);
        Assert.assertEquals((long)1L, (long)engineXml.getPlugins().size());
        ProcessEnginePluginXml pluginXml = (ProcessEnginePluginXml)engineXml.getPlugins().get(0);
        Map properties = pluginXml.getProperties();
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertEquals((Object)System.getProperty("java.version"), properties.get("prop1"));
        Assert.assertEquals((Object)("prefix-" + System.getProperty("os.name")), properties.get("prop2"));
    }
}

