/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String MESSAGE_BOUNDARY_PROCESS_KEY = "messageBoundaryProcess";
    protected static final String SIGNAL_BOUNDARY_PROCESS_KEY = "signalBoundaryProcess";
    protected static final String SIGNAL_START_PROCESS_KEY = "signalStartProcess";
    protected static final String THROW_WARNING_SIGNAL_PROCESS_KEY = "throwWarningSignalProcess";
    protected static final String THROW_ALERT_SIGNAL_PROCESS_KEY = "throwAlertSignalProcess";
    protected boolean ensureSpecificVariablePermission;

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/signalBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/signalStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/throwWarningSignalEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/throwAlertSignalEventProcess.bpmn20.xml");
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
    }

    @Test
    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
    }

    @Test
    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
    }

    @Test
    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testStartProcessInstanceByKeyWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByKeyWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByKeyWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testStartProcessInstanceByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testStartProcessInstanceAtActivitiesByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testStartProcessInstanceAtActivitiesByKeyWithoutAuthorization() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceAtActivitiesByKeyWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceAtActivitiesByKeyWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceAtActivitiesById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testStartProcessInstanceAtActivitiesByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceAtActivitiesByIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceAtActivitiesByIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByMessageWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByMessageWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByMessageWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByMessage() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testStartProcessInstanceByMessageAndProcDefIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByMessageAndProcDefIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByMessageAndProcDefIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByMessageAndProcDefId() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.deleteProcessInstance(processInstanceId, null);
            Assert.fail((String)"Exception expected: It should not be possible to delete a process instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testDeleteProcessInstanceWithDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.testRule.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteProcessInstanceWithDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.testRule.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteProcessInstanceWithDeleteInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.testRule.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.testRule.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    @Test
    public void testGetActiveActivityIdsWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActiveActivityIds(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve active ativity ids");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetActiveActivityIdsWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        Assert.assertNotNull((Object)activityIds);
        Assert.assertFalse((boolean)activityIds.isEmpty());
    }

    @Test
    public void testGetActiveActivityIdsWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        Assert.assertNotNull((Object)activityIds);
        Assert.assertFalse((boolean)activityIds.isEmpty());
    }

    @Test
    public void testGetActiveActivityIdsWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        Assert.assertNotNull((Object)activityIds);
        Assert.assertFalse((boolean)activityIds.isEmpty());
    }

    @Test
    public void testGetActiveActivityIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        Assert.assertNotNull((Object)activityIds);
        Assert.assertFalse((boolean)activityIds.isEmpty());
    }

    @Test
    public void testGetActivityInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActivityInstance(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve ativity instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetActivityInstanceWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstance);
    }

    @Test
    public void testGetActivityInstanceWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstance);
    }

    @Test
    public void testGetActivityInstanceWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstance);
    }

    @Test
    public void testGetActivityInstanceIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstance);
    }

    @Test
    public void testSignalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.signal(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be possible to signal an execution");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSignalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Test
    public void testSignalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Test
    public void testSignalWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signal(processInstanceId);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Test
    public void testSignal() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstance);
    }

    @Test
    public void testSignalEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.signalEventReceived("alert");
            Assert.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSignalEventReceivedWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSignalEventReceivedWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSignalEventReceivedWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSignalEventReceived() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSignalEventReceivedTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.signalEventReceived("alert");
            Assert.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(secondProcessInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSignalEventReceivedTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    @Test
    public void testSignalEventReceivedByExecutionIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.signalEventReceived("alert", executionId);
            Assert.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSignalEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSignalEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testStartProcessInstanceBySignalEventReceivedWithoutAuthorization() {
        try {
            this.runtimeService.signalEventReceived("warning");
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceBySignalEventReceivedWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.signalEventReceived("warning");
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'signalStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceBySignalEventReceived() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.signalEventReceived("warning");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
    }

    public void FAILING_testStartProcessInstanceByThrowSignalEventWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_WARNING_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByKey(THROW_WARNING_SIGNAL_PROCESS_KEY);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'signalStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByThrowSignalEvent() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_WARNING_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.startProcessInstanceByKey(THROW_WARNING_SIGNAL_PROCESS_KEY);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
    }

    public void FAILING_testThrowSignalEventWithoutAuthorization() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_ALERT_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByKey(THROW_ALERT_SIGNAL_PROCESS_KEY);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testThrowSignalEvent() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_ALERT_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.startProcessInstanceByKey(THROW_ALERT_SIGNAL_PROCESS_KEY);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testMessageEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
            Assert.fail((String)"Exception expected: It should not be possible to trigger a message event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testMessageEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testMessageEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateMessageExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.correlateMessage("boundaryInvoiceMessage");
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testCorrelateMessageExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateMessageExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateMessageExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateMessageExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateMessageProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testCorrelateMessageProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testCorrelateMessageProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testCorrelateMessageProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.correlateMessage("startInvoiceMessage");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateAllExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testCorrelateAllExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateAllExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateAllExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateAllExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testCorrelateAllTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            Assert.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(secondProcessInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testCorrelateAllTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            Assert.assertEquals((Object)"taskAfterBoundaryEvent", (Object)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    @Test
    public void testCorrelateAllProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testCorrelateAllProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    @Test
    public void testCorrelateAllProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            Assert.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    @Test
    public void testCorrelateAllProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testSuspendProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    @Test
    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByIdWithSuspendPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByIdWithSuspendPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByIdWithSuspendInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be posssible to activate a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    @Test
    public void testActivateProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByIdWithSuspendPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByIdWithSuspendPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByIdWithSuspendInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.startProcessInstanceByKey(PROCESS_KEY).getProcessDefinitionId();
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithSuspendInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithSuspendInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithSuspendInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithSuspendInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testModifyProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testModifyProcessInstanceWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        Assert.assertFalse((boolean)tasks.isEmpty());
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testModifyProcessInstanceWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        Assert.assertFalse((boolean)tasks.isEmpty());
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testModifyProcessInstanceWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        Assert.assertFalse((boolean)tasks.isEmpty());
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testModifyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        Assert.assertFalse((boolean)tasks.isEmpty());
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testDeleteProcessInstanceByModifyingWithoutDeleteAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        try {
            this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Test
    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Test
    public void testDeleteProcessInstanceByModifyingWithoutDeleteInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.UPDATE_INSTANCE);
        authorization.addPermission((Permission)Permissions.DELETE_INSTANCE);
        this.saveAuthorization(authorization);
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Test
    public void testClearProcessInstanceAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        String taskId = this.selectSingleTask().getId();
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
    }

    @Test
    public void testDeleteProcessInstanceClearAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
    }

    @Test
    public void testGetVariableWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariable(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariable(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariableWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableLocalWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariableLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableLocalWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableLocalWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testGetVariableTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariableTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableLocalTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariableLocalTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableLocalTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableLocalTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableLocalTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableLocalTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariableLocalTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testGetVariablesWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariables(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariables(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesLocalWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesLocalWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testGetVariablesTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testGetVariablesLocalTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesLocalTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testGetVariablesLocalTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testGetVariablesByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesLocalByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesLocalByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testGetVariablesLocalByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesLocalByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    @Test
    public void testGetVariablesTypedByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesTypedByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesTypedByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testGetVariablesTypedByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testGetVariablesLocalTypedByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(processInstanceId, message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            Assert.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetVariablesLocalTypedByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testGetVariablesLocalTypedByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testGetVariablesLocalTypedByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    @Test
    public void testSetVariableWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.verifyMessageIsValid(processInstanceId, message);
        }
    }

    @Test
    public void testSetVariableWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariable(processInstanceId);
    }

    @Test
    public void testSetVariableWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariable(processInstanceId);
    }

    @Test
    public void testSetVariableWithUpdateInstanceInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testSetVariableWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariable(processInstanceId);
    }

    @Test
    public void testSetVariableWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    @Test
    public void testSetVariableWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    @Test
    public void testSetVariableWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    @Test
    public void testSetVariableWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    @Test
    public void testSetVariableLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testSetVariableLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariableLocal(processInstanceId);
    }

    @Test
    public void testSetVariableLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariableLocal(processInstanceId);
    }

    @Test
    public void testSetVariableLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariableLocal(processInstanceId);
    }

    @Test
    public void testSetVariableLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    @Test
    public void testSetVariableLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    @Test
    public void testSetVariableLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    @Test
    public void testSetVariableLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    @Test
    public void testSetVariableLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testSetVariablesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariables(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testSetVariablesLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testSetVariablesLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariable(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testRemoveVariableWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testRemoveVariableLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariableLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testRemoveVariablesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testRemoveVariablesLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testRemoveVariablesLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testUpdateVariablesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            Assert.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    @Test
    public void testUpdateVariablesLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    @Test
    public void testUpdateVariablesLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    protected void verifyQueryResults(ProcessInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyMessageIsValid(String processInstanceId, String message) {
        this.testRule.assertTextPresent(this.userId, message);
        this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        this.testRule.assertTextPresent(ProcessInstancePermissions.UPDATE_VARIABLE.getName(), message);
        this.testRule.assertTextPresent(processInstanceId, message);
        this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
        this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
        this.testRule.assertTextPresent(ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE.getName(), message);
        this.testRule.assertTextPresent(PROCESS_KEY, message);
        this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
    }

    protected void verifyVariableInstanceCountDisabledAuthorization(int count) {
        this.disableAuthorization();
        this.verifyQueryResults(this.runtimeService.createVariableInstanceQuery(), count);
        this.enableAuthorization();
    }

    protected void verifySetVariable(String processInstanceId) {
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariableLocal(String processInstanceId) {
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariables(String processInstanceId) {
        this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariablesLocal(String processInstanceId) {
        this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifyRemoveVariable(String processInstanceId) {
        this.runtimeService.removeVariable(processInstanceId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariableLocal(String processInstanceId) {
        this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariables(String processInstanceId) {
        this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariablesLocal(String processInstanceId) {
        this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariables(String processInstanceId) {
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariablesLocal(String processInstanceId) {
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void setReadVariableAsDefaultReadVariablePermission() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }

    protected void verifyGetVariables(Map<String, Object> variables) {
        Assert.assertNotNull(variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get("aVariableName"));
    }
}

