/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.repository.ResourceDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIn;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class HistoryServiceAsyncOperationsTest
extends AbstractAsyncOperationsTest {
    protected static final String TEST_REASON = "test reason";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected TaskService taskService;
    protected List<String> historicProcessInstances;

    @Before
    public void setup() {
        this.initDefaults(this.engineRule);
        this.taskService = this.engineRule.getTaskService();
        this.prepareData();
    }

    protected void prepareData() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.startTestProcesses(2);
        for (Task activeTask : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(activeTask.getId());
        }
        this.historicProcessInstances = new ArrayList<String>();
        for (HistoricProcessInstance pi : this.historyService.createHistoricProcessInstanceQuery().list()) {
            this.historicProcessInstances.add(pi.getId());
        }
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithList() throws Exception {
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, TEST_REASON);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithListForDeletedDeployment() throws Exception {
        this.prepareData();
        ProcessDefinitionQuery definitionQuery = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        String firstDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(1)).singleResult()).getDeploymentId();
        String secondDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(2)).singleResult()).getDeploymentId();
        this.engineRule.getRepositoryService().deleteDeployment(secondDeploymentId);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, TEST_REASON);
        Job seedJob = this.getSeedJob(batch);
        Assert.assertEquals((Object)firstDeploymentId, (Object)seedJob.getDeploymentId());
        this.executeSeedJob(batch);
        seedJob = this.getSeedJob(batch);
        Assert.assertEquals((Object)firstDeploymentId, (Object)seedJob.getDeploymentId());
        this.executeSeedJob(batch);
        JobQuery batchJobQuery = this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId());
        List batchJobs = batchJobQuery.list();
        MatcherAssert.assertThat((Object)batchJobs.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((Job)batchJobs.get(0)).getDeploymentId(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)firstDeploymentId), (Matcher)Is.is((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)((Job)batchJobs.get(1)).getDeploymentId(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)firstDeploymentId), (Matcher)Is.is((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)((Job)batchJobs.get(0)).getDeploymentId(), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)((Job)batchJobs.get(1)).getDeploymentId())));
        MatcherAssert.assertThat((Object)this.historicProcessInstances.size(), (Matcher)Is.is((Object)4));
        MatcherAssert.assertThat((Object)this.getHistoricProcessInstanceCountByDeploymentId(firstDeploymentId), (Matcher)Is.is((Object)2L));
        this.getJobIdsByDeployment(batchJobs, firstDeploymentId).forEach(arg_0 -> ((ManagementService)this.managementService).executeJob(arg_0));
        MatcherAssert.assertThat((Object)this.getHistoricProcessInstanceCountByDeploymentId(firstDeploymentId), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)Is.is((Object)2L));
        batchJobQuery.list().forEach(j -> this.managementService.executeJob(j.getId()));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithListInDifferentDeployments() throws Exception {
        this.prepareData();
        ProcessDefinitionQuery definitionQuery = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        String firstDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(1)).singleResult()).getDeploymentId();
        String secondDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(2)).singleResult()).getDeploymentId();
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, TEST_REASON);
        this.executeSeedJobs(batch, 2);
        List batchJobs = this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list();
        MatcherAssert.assertThat((Object)batchJobs.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((Job)batchJobs.get(0)).getDeploymentId(), (Matcher)IsIn.isOneOf((Object[])new String[]{firstDeploymentId, secondDeploymentId}));
        MatcherAssert.assertThat((Object)((Job)batchJobs.get(1)).getDeploymentId(), (Matcher)IsIn.isOneOf((Object[])new String[]{firstDeploymentId, secondDeploymentId}));
        MatcherAssert.assertThat((Object)((Job)batchJobs.get(0)).getDeploymentId(), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)((Job)batchJobs.get(1)).getDeploymentId())));
        MatcherAssert.assertThat((Object)this.historicProcessInstances.size(), (Matcher)Is.is((Object)4));
        MatcherAssert.assertThat((Object)this.getHistoricProcessInstanceCountByDeploymentId(firstDeploymentId), (Matcher)Is.is((Object)2L));
        MatcherAssert.assertThat((Object)this.getHistoricProcessInstanceCountByDeploymentId(secondDeploymentId), (Matcher)Is.is((Object)2L));
        this.getJobIdsByDeployment(batchJobs, firstDeploymentId).forEach(arg_0 -> ((ManagementService)this.managementService).executeJob(arg_0));
        MatcherAssert.assertThat((Object)this.getHistoricProcessInstanceCountByDeploymentId(firstDeploymentId), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)this.getHistoricProcessInstanceCountByDeploymentId(secondDeploymentId), (Matcher)Is.is((Object)2L));
        this.getJobIdsByDeployment(batchJobs, secondDeploymentId).forEach(arg_0 -> ((ManagementService)this.managementService).executeJob(arg_0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithEmptyList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.historyService.deleteHistoricProcessInstancesAsync(new ArrayList(), TEST_REASON);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithFake() throws Exception {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        processInstanceIds.add(this.historicProcessInstances.get(0));
        processInstanceIds.add("aFakeId");
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(processInstanceIds, TEST_REASON);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithQueryAndList() throws Exception {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.historicProcessInstances.get(0));
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances.subList(1, this.historicProcessInstances.size()), query, TEST_REASON);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithQuery() throws Exception {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet<String>(this.historicProcessInstances));
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(query, TEST_REASON);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithEmptyQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().unfinished();
        this.historyService.deleteHistoricProcessInstancesAsync(query, TEST_REASON);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithNonExistingIDAsQuery() throws Exception {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        processInstanceIds.add(this.historicProcessInstances.get(0));
        processInstanceIds.add("aFakeId");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(processInstanceIds));
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(query, TEST_REASON);
        this.completeSeedJobs(batch);
        this.executeBatchJobs(batch);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithoutDeleteReason() throws Exception {
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, null);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        MatcherAssert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)0));
        this.assertNoHistoryForTasks();
        this.assertHistoricBatchExists(this.testRule);
        this.assertAllHistoricProcessInstancesAreDeleted();
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithNullList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.historyService.deleteHistoricProcessInstancesAsync((List)null, TEST_REASON);
    }

    @Test
    public void testDeleteHistoryProcessInstancesAsyncWithNullQuery() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.historyService.deleteHistoricProcessInstancesAsync((HistoricProcessInstanceQuery)null, TEST_REASON);
    }

    @Test
    public void shouldSetInvocationsPerBatchType() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("historic-instance-deletion", 42);
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(this.historicProcessInstances, TEST_REASON);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    protected long getHistoricProcessInstanceCountByDeploymentId(String deploymentId) {
        Set processDefinitionIds = this.engineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deploymentId).list().stream().map(ResourceDefinition::getId).collect(Collectors.toSet());
        return this.historyService.createHistoricProcessInstanceQuery().list().stream().filter(hpi -> processDefinitionIds.contains(hpi.getProcessDefinitionId())).map(HistoricProcessInstance::getId).count();
    }

    protected void assertNoHistoryForTasks() {
        if (!this.testRule.isHistoryLevelNone()) {
            Assert.assertThat((Object)this.historyService.createHistoricTaskInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        }
    }

    protected void assertAllHistoricProcessInstancesAreDeleted() {
        MatcherAssert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)Is.is((Object)0L));
    }
}

