/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.PasswordPolicy;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.identity.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CustomPasswordPolicyTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private IdentityService identityService;

    @Before
    public void init() {
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setPasswordPolicy((PasswordPolicy)new DefaultPasswordPolicyImpl());
        this.processEngineConfiguration.setEnablePasswordPolicy(true);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setPasswordPolicy(null);
        this.processEngineConfiguration.setEnablePasswordPolicy(false);
        this.identityService.deleteUser("user");
    }

    @Test
    public void testPasswordPolicyConfiguration() {
        PasswordPolicy policy = this.processEngineConfiguration.getPasswordPolicy();
        Assert.assertThat((Object)policy.getClass().isAssignableFrom(DefaultPasswordPolicyImpl.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)policy.getRules().size(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void testCustomPasswordPolicyWithCompliantPassword() {
        User user = this.identityService.newUser("user");
        user.setPassword("this-is-1-STRONG-password");
        this.identityService.saveUser(user);
        Assert.assertThat((Object)this.identityService.createUserQuery().userId(user.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCustomPasswordPolicyWithNonCompliantPassword() {
        this.thrown.expect(ProcessEngineException.class);
        User user = this.identityService.newUser("user");
        user.setPassword("weakpassword");
        this.identityService.saveUser(user);
        this.thrown.expectMessage("Password does not match policy");
        Assert.assertThat((Object)this.identityService.createUserQuery().userId(user.getId()).count(), (Matcher)CoreMatchers.is((Object)0L));
    }
}

