/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.telemetry.CommandCounter;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.NoInitMessageInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TelemetryDynamicDataTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected ProcessEngine processEngineInMem;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.configuration.getRuntimeService();
        this.taskService = this.configuration.getTaskService();
        this.managementService = this.configuration.getManagementService();
        this.clearMetrics();
    }

    @After
    public void tearDown() {
        this.clearMetrics();
        this.configuration.setTelemetryRegistry(new TelemetryRegistry());
        this.managementService.toggleTelemetry(false);
        if (this.processEngineInMem != null) {
            ((ProcessEngineConfigurationImpl)this.processEngineInMem.getProcessEngineConfiguration()).getManagementService().toggleTelemetry(false);
            ProcessEngines.unregister((ProcessEngine)this.processEngineInMem);
            this.processEngineInMem.close();
        }
    }

    public void clearMetrics() {
        this.configuration.getTelemetryRegistry().clear();
        this.clearMetrics(this.configuration.getMetricsRegistry().getDbMeters());
        this.clearMetrics(this.configuration.getMetricsRegistry().getTelemetryMeters());
    }

    protected void clearMetrics(Map<String, Meter> meters) {
        for (Meter meter : meters.values()) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    public void shouldCountCommandsFromEngineStart() {
        this.processEngineInMem = new NoInitMessageInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setInitializeTelemetry(true).buildProcessEngine();
        TelemetryRegistry telemetryRegistry = this.processEngineInMem.getProcessEngineConfiguration().getTelemetryRegistry();
        Map entries = telemetryRegistry.getCommands();
        Assertions.assertThat((int)entries.size()).isEqualTo(3);
        Assertions.assertThat(entries.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"IsTelemetryEnabledCmd", "NoInitMessageBootstrapEngineCommand", "GetLicenseKeyCmd"});
        for (String commandName : entries.keySet()) {
            Assertions.assertThat((long)((CommandCounter)entries.get(commandName)).get()).isEqualTo(1L);
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCountAfterCleaning() {
        this.managementService.toggleTelemetry(true);
        this.clearCommandCounts();
        Map entries = this.configuration.getTelemetryRegistry().getCommands();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        this.runtimeService.setVariable(processInstanceId, "foo", (Object)"bar");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        this.taskService.complete(task.getId());
        Assertions.assertThat((int)entries.size()).isEqualTo(4);
        Object[] expectedExcutedCommands = new String[]{"StartProcessInstanceCmd", "SetExecutionVariablesCmd", "TaskQueryImpl", "CompleteTaskCmd"};
        Assertions.assertThat(entries.keySet()).contains(expectedExcutedCommands);
        for (Object commandName : expectedExcutedCommands) {
            Assertions.assertThat((long)((CommandCounter)entries.get(commandName)).get()).isEqualTo(1L);
        }
    }

    @Test
    public void shouldCollectCommandsDataOnlyWhenTelemetryEnabled() {
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        Map commands = this.configuration.getTelemetryRegistry().getCommands();
        Assertions.assertThat((int)commands.size()).isZero();
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        Assertions.assertThat((int)commands.size()).isEqualTo(3);
        Object[] expectedExcutedCommands = new String[]{"GetLicenseKeyCmd", "GetHistoryLevelCmd", "TelemetryConfigureCmd"};
        Assertions.assertThat(commands.keySet()).isSubsetOf(expectedExcutedCommands);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotCollectMetricsDataWhenTelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        Map telemetryMeters = this.configuration.getMetricsRegistry().getTelemetryMeters();
        for (String meter : telemetryMeters.keySet()) {
            Assertions.assertThat((long)((Meter)telemetryMeters.get(meter)).get()).isZero();
        }
    }

    protected void clearCommandCounts() {
        this.configuration.getTelemetryRegistry().clear();
    }
}

