/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.api.delegate.AssertingJavaDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyDelegateExecutionTest
extends PluggableProcessEngineTest {
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";

    @Test
    public void testSingleExecution() {
        this.testRule.deployForTenant("tenant1", ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done());
        AssertingJavaDelegate.addAsserts(MultiTenancyDelegateExecutionTest.hasTenantId("tenant1"));
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
    }

    @Test
    public void testConcurrentExecution() {
        this.testRule.deployForTenant("tenant1", ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().parallelGateway("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).parallelGateway("join").endEvent().moveToNode("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).connectTo("join").done());
        AssertingJavaDelegate.addAsserts(MultiTenancyDelegateExecutionTest.hasTenantId("tenant1"));
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
    }

    @Test
    public void testEmbeddedSubprocess() {
        this.testRule.deployForTenant("tenant1", ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().subProcess().embeddedSubProcess().startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().subProcessDone().endEvent().done());
        AssertingJavaDelegate.addAsserts(MultiTenancyDelegateExecutionTest.hasTenantId("tenant1"));
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
    }

    protected void startProcessInstance(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
    }

    @After
    public void tearDown() throws Exception {
        AssertingJavaDelegate.clear();
    }

    protected static AssertingJavaDelegate.DelegateExecutionAsserter hasTenantId(final String expectedTenantId) {
        return new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                Assert.assertThat((Object)execution.getTenantId(), (Matcher)CoreMatchers.is((Object)expectedTenantId));
            }
        };
    }
}

