/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyFilterServiceTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String[] TENANT_IDS = new String[]{"tenant1", "tenant2"};
    protected String filterId = null;
    protected final List<String> taskIds = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        this.createTaskWithoutTenantId();
        this.createTaskForTenant(TENANT_ONE);
        this.createTaskForTenant(TENANT_TWO);
    }

    @Test
    public void testCreateFilterWithTenantIdCriteria() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(TENANT_IDS);
        this.filterId = this.createFilter(query);
        Filter savedFilter = this.filterService.getFilter(this.filterId);
        TaskQueryImpl savedQuery = (TaskQueryImpl)savedFilter.getQuery();
        Assert.assertThat((Object)savedQuery.getTenantIds(), (Matcher)CoreMatchers.is((Object)TENANT_IDS));
    }

    @Test
    public void testCreateFilterWithNoTenantIdCriteria() {
        TaskQuery query = this.taskService.createTaskQuery().withoutTenantId();
        this.filterId = this.createFilter(query);
        Filter savedFilter = this.filterService.getFilter(this.filterId);
        TaskQueryImpl savedQuery = (TaskQueryImpl)savedFilter.getQuery();
        Assert.assertThat((Object)savedQuery.isWithoutTenantId(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)savedQuery.getTenantIds(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFilterTasksNoTenantIdSet() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testFilterTasksByTenantIds() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(TENANT_IDS);
        this.filterId = this.createFilter(query);
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)2L));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("testTask");
        Assert.assertThat((Object)this.filterService.count(this.filterId, (Query)extendingQuery), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testFilterTasksWithoutTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().withoutTenantId();
        this.filterId = this.createFilter(query);
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)1L));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("testTask");
        Assert.assertThat((Object)this.filterService.count(this.filterId, (Query)extendingQuery), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFilterTasksByExtendingQueryWithTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)this.filterService.count(this.filterId, (Query)extendingQuery), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFilterTasksByExtendingQueryWithoutTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().withoutTenantId();
        Assert.assertThat((Object)this.filterService.count(this.filterId, (Query)extendingQuery), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFilterTasksWithNoAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, null);
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFilterTasksWithAuthenticatedTenant() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testFilterTasksWithAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testFilterTasksByTenantIdNoAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, null);
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testFilterTasksByTenantIdWithAuthenticatedTenant() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFilterTasksByExtendingQueryWithTenantIdNoAuthenticatedTenants() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, null);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)this.filterService.count(this.filterId, (Query)extendingQuery), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testFilterTasksByExtendingQueryWithTenantIdAuthenticatedTenant() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        this.filterId = this.createFilter(query);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)this.filterService.count(this.filterId, (Query)extendingQuery), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFilterTasksWithDisabledTenantCheck() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.filterId = this.createFilter(query);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        Assert.assertThat((Object)this.filterService.count(this.filterId), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected void createTaskWithoutTenantId() {
        this.createTaskForTenant(null);
    }

    protected void createTaskForTenant(String tenantId) {
        Task newTask = this.taskService.newTask();
        newTask.setName("testTask");
        if (tenantId != null) {
            newTask.setTenantId(tenantId);
        }
        this.taskService.saveTask(newTask);
        this.taskIds.add(newTask.getId());
    }

    protected String createFilter(TaskQuery query) {
        Filter newFilter = this.filterService.newTaskFilter("myFilter");
        newFilter.setQuery((Query)query);
        return this.filterService.saveFilter(newFilter).getId();
    }

    @After
    public void tearDown() throws Exception {
        this.filterService.deleteFilter(this.filterId);
        this.identityService.clearAuthentication();
        for (String taskId : this.taskIds) {
            this.taskService.deleteTask(taskId, true);
        }
    }
}

