/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMessageCorrelationTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance MESSAGE_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"messageStart").startEvent().message("message")).userTask().endEvent().done();
    protected static final BpmnModelInstance MESSAGE_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"messageCatch").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void correlateMessageToStartEventNoTenantIdSetForNonTenant() {
        this.testRule.deploy(MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void correlateMessageToStartEventNoTenantIdSetForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateMessageToStartEventWithoutTenantId() {
        this.testRule.deploy(MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void correlateMessageToStartEventWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToIntermediateCatchEventNoTenantIdSetForNonTenant() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("messageCatch");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateMessageToIntermediateCatchEventNoTenantIdSetForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("messageCatch");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateMessageToIntermediateCatchEventWithoutTenantId() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Task)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void correlateMessageToIntermediateCatchEventWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToStartAndIntermediateCatchEventWithoutTenantId() {
        this.testRule.deploy(MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlateAll();
        List tasks = this.engineRule.getTaskService().createTaskQuery().list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void correlateMessageToStartAndIntermediateCatchEventWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlateAll();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToMultipleIntermediateCatchEventsWithoutTenantId() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlateAll();
        List tasks = this.engineRule.getTaskService().createTaskQuery().list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void correlateMessageToMultipleIntermediateCatchEventsWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlateAll();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateStartMessageWithoutTenantId() {
        this.testRule.deploy(MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlateStartMessage();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void correlateStartMessageWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlateStartMessage();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessagesToStartEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateAll();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateMessagesToIntermediateCatchEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateAll();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateMessagesToStartAndIntermediateCatchEventForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateAll();
        Assert.assertThat((Object)this.engineRule.getRuntimeService().createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.engineRule.getTaskService().createTaskQuery().tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void failToCorrelateMessageToIntermediateCatchEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.thrown.expect(MismatchingMessageCorrelationException.class);
        this.thrown.expectMessage("Cannot correlate a message with name 'message' to a single execution");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
    }

    @Test
    public void testSubscriptionsWhenDeletingGroupsProcessDefinitionsByIds() {
        String processDefId1 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, MESSAGE_START_PROCESS).getId();
        String processDefId2 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, MESSAGE_START_PROCESS).getId();
        String processDefId3 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, MESSAGE_START_PROCESS).getId();
        String processDefId4 = this.testRule.deployAndGetDefinition(MESSAGE_START_PROCESS).getId();
        String processDefId5 = this.testRule.deployAndGetDefinition(MESSAGE_START_PROCESS).getId();
        String processDefId6 = this.testRule.deployAndGetDefinition(MESSAGE_START_PROCESS).getId();
        BpmnModelInstance processAnotherKey = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"anotherKey").startEvent().message("sophisticated message")).userTask().endEvent().done();
        String processDefId7 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        String processDefId8 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        String processDefId9 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        Assert.assertEquals((long)3L, (long)this.engineRule.getRuntimeService().createEventSubscriptionQuery().count());
        this.engineRule.getRepositoryService().deleteProcessDefinitions().byIds(new String[]{processDefId8, processDefId5, processDefId3, processDefId9, processDefId1}).delete();
        List list = this.engineRule.getRuntimeService().createEventSubscriptionQuery().list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (EventSubscription eventSubscription : list) {
            EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)eventSubscription;
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId2)) {
                Assert.assertEquals((Object)TENANT_ONE, (Object)eventSubscription.getTenantId());
                continue;
            }
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId6)) {
                Assert.assertEquals(null, (Object)eventSubscription.getTenantId());
                continue;
            }
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId7)) {
                Assert.assertEquals((Object)TENANT_ONE, (Object)eventSubscription.getTenantId());
                continue;
            }
            Assert.fail((String)("This process definition '" + eventSubscriptionEntity.getConfiguration() + "' and the respective event subscription should not exist."));
        }
    }

    @Test
    public void failToCorrelateMessageToStartEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.thrown.expect(MismatchingMessageCorrelationException.class);
        this.thrown.expectMessage("Cannot correlate a message with name 'message' to a single process definition");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
    }

    @Test
    public void failToCorrelateStartMessageForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.thrown.expect(MismatchingMessageCorrelationException.class);
        this.thrown.expectMessage("Cannot correlate a message with name 'message' to a single process definition");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateStartMessage();
    }

    @Test
    public void failToCorrelateMessageByProcessInstanceIdWithoutTenantId() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Cannot specify a tenant-id");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").processInstanceId("id").withoutTenantId().correlate();
    }

    @Test
    public void failToCorrelateMessageByProcessInstanceIdAndTenantId() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Cannot specify a tenant-id");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").processInstanceId("id").tenantId(TENANT_ONE).correlate();
    }

    @Test
    public void failToCorrelateMessageByProcessDefinitionIdWithoutTenantId() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Cannot specify a tenant-id");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").processDefinitionId("id").withoutTenantId().correlateStartMessage();
    }

    @Test
    public void failToCorrelateMessageByProcessDefinitionIdAndTenantId() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Cannot specify a tenant-id");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").processDefinitionId("id").tenantId(TENANT_ONE).correlateStartMessage();
    }
}

