/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn;

import java.util.Arrays;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyCreateCaseInstanceTest
extends PluggableProcessEngineTest {
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CASE_DEFINITION_KEY = "oneTaskCase";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Test
    public void testFailToCreateCaseInstanceByIdWithoutTenantId() {
        this.testRule.deploy(CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).caseDefinitionWithoutTenantId().create();
            Assert.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByIdWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).caseDefinitionTenantId(TENANT_ONE).create();
            Assert.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyForNonExistingTenantID() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId("nonExistingTenantId").create();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key 'oneTaskCase' and tenant-id 'nonExistingTenantId'"));
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants."));
        }
    }

    @Test
    public void testCreateCaseInstanceByKeyWithoutTenantId() {
        this.testRule.deploy(CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionWithoutTenantId().create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((CaseInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testCreateCaseInstanceByKeyForAnyTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        Assert.assertThat((Object)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCreateCaseInstanceByKeyAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        Assert.assertThat((Object)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCreateCaseInstanceByKeyWithoutTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deploy(CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionWithoutTenantId().create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key 'oneTaskCase'"));
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyWithTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the case definition"));
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).create();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the case definition"));
        }
    }

    @Test
    public void testCreateCaseInstanceByKeyWithTenantIdAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCreateCaseInstanceByIdAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.withCaseDefinition(caseDefinition.getId()).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCreateCaseInstanceByKeyWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCreateCaseInstanceByKeyWithTenantIdDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }
}

