/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMessageCorrelationCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance MESSAGE_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"messageStart").startEvent().message("message")).userTask().endEvent().done();
    protected static final BpmnModelInstance MESSAGE_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"messageCatch").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void correlateMessageToStartEventNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.testRule.deploy(MESSAGE_START_PROCESS);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").correlateStartMessage();
        this.identityService.clearAuthentication();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateMessageToStartEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createMessageCorrelation("message").correlateStartMessage();
        this.identityService.clearAuthentication();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToStartEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").tenantId(TENANT_ONE).correlateStartMessage();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").correlate();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.taskService.createTaskQuery().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateMessageToIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createMessageCorrelation("message").correlate();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").tenantId(TENANT_ONE).correlate();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToStartAndIntermediateCatchEventWithNoAuthenticatedTenants() {
        this.testRule.deploy(MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").correlateAll();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.taskService.createTaskQuery().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void correlateMessageToStartAndIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createMessageCorrelation("message").correlateAll();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void correlateMessageToStartAndIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").correlateAll();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void failToCorrelateMessageByProcessInstanceIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        ProcessInstance processInstance = this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.thrown.expect(MismatchingMessageCorrelationException.class);
        this.thrown.expectMessage("Cannot correlate message");
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").processInstanceId(processInstance.getId()).correlate();
    }

    @Test
    public void correlateMessageByProcessInstanceIdWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        ProcessInstance processInstance = this.runtimeService.createProcessInstanceByKey("messageCatch").execute();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createMessageCorrelation("message").processInstanceId(processInstance.getId()).correlate();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void failToCorrelateMessageByProcessDefinitionIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("messageStart").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot create an instance of the process definition");
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createMessageCorrelation("message").processDefinitionId(processDefinition.getId()).correlateStartMessage();
    }

    @Test
    public void correlateMessageByProcessDefinitionIdWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("messageStart").singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createMessageCorrelation("message").processDefinitionId(processDefinition.getId()).correlateStartMessage();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }
}

