/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMessageEventReceivedCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance MESSAGE_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"messageCatch").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").singleResult();
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.messageEventReceived("message", execution.getId());
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.taskService.createTaskQuery().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.messageEventReceived("message", execution.getId());
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.runtimeService.messageEventReceived("message", execution.getId());
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToCorrelateReceivedMessageToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance");
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.messageEventReceived("message", execution.getId());
    }
}

