/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancySignalReceiveCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance SIGNAL_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"signalStart").startEvent().signal("signal")).userTask().endEvent().done();
    protected static final BpmnModelInstance SIGNAL_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"signalCatch").startEvent().intermediateCatchEvent().signal("signal")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void sendSignalToStartEventNoAuthenticatedTenants() {
        this.testRule.deploy(SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createSignalEvent("signal").send();
        this.identityService.clearAuthentication();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void sendSignalToStartEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createSignalEvent("signal").send();
        this.identityService.clearAuthentication();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void sendSignalToStartEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deploy(SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createSignalEvent("signal").send();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.taskService.createTaskQuery().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createSignalEvent("signal").send();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createSignalEvent("signal").send();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.taskService.createTaskQuery().withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createSignalEvent("signal").send();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventWithExecutionIdAndAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("signalCatch").signalEventSubscriptionName("signal").singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createSignalEvent("signal").executionId(execution.getId()).send();
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void failToSendSignalToIntermediateCatchEventWithExecutionIdAndNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("signalCatch").signalEventSubscriptionName("signal").singleResult();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance");
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createSignalEvent("signal").executionId(execution.getId()).send();
    }

    @Test
    public void signalIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deploy(SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("signalCatch").signalEventSubscriptionName("signal").singleResult();
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.signal(execution.getId(), "signal", null, null);
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void signalIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("signalCatch").signalEventSubscriptionName("signal").singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.signal(execution.getId(), "signal", null, null);
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void signalIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("signalCatch").signalEventSubscriptionName("signal").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.signal(execution.getId(), "signal", null, null);
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToSignalIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("signalCatch").signalEventSubscriptionName("signal").singleResult();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance");
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.signal(execution.getId(), "signal", null, null);
    }
}

