/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ProcessDefinitionCandidateTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String CANDIDATE_STARTER_USER = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterUser.bpmn20.xml";
    protected static final String CANDIDATE_STARTER_USERS = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterUsers.bpmn20.xml";
    protected static final String CANDIDATE_STARTER_GROUP = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterGroup.bpmn20.xml";
    protected static final String CANDIDATE_STARTER_GROUPS = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterGroups.bpmn20.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;

    @Before
    public void setUp() throws Exception {
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void shouldPropagateTenantIdToCandidateStarterUser() {
        DeploymentBuilder builder = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_USER).tenantId(TENANT_ONE);
        this.testRule.deploy(builder);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)links.size());
        IdentityLink link = (IdentityLink)links.get(0);
        Assert.assertNotNull((Object)link.getTenantId());
        Assert.assertEquals((Object)TENANT_ONE, (Object)link.getTenantId());
    }

    @Test
    public void shouldPropagateTenantIdToCandidateStarterUsers() {
        DeploymentBuilder builder = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_USERS).tenantId(TENANT_ONE);
        this.testRule.deploy(builder);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition.getId());
        Assert.assertEquals((long)3L, (long)links.size());
        for (IdentityLink link : links) {
            Assert.assertNotNull((Object)link.getTenantId());
            Assert.assertEquals((Object)TENANT_ONE, (Object)link.getTenantId());
        }
    }

    @Test
    public void shouldPropagateTenantIdToCandidateStarterGroup() {
        DeploymentBuilder builder = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_GROUP).tenantId(TENANT_ONE);
        this.testRule.deploy(builder);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)links.size());
        IdentityLink link = (IdentityLink)links.get(0);
        Assert.assertNotNull((Object)link.getTenantId());
        Assert.assertEquals((Object)TENANT_ONE, (Object)link.getTenantId());
    }

    @Test
    public void shouldPropagateTenantIdToCandidateStarterGroups() {
        DeploymentBuilder builder = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_GROUPS).tenantId(TENANT_ONE);
        this.testRule.deploy(builder);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition.getId());
        Assert.assertEquals((long)3L, (long)links.size());
        for (IdentityLink link : links) {
            Assert.assertNotNull((Object)link.getTenantId());
            Assert.assertEquals((Object)TENANT_ONE, (Object)link.getTenantId());
        }
    }
}

