/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CaseExecutionQueryTest
extends PluggableProcessEngineTest {
    private static String CASE_DEFINITION_KEY = "oneTaskCase";
    private static String CASE_DEFINITION_KEY_2 = "twoTaskCase";

    @Before
    public void setUp() throws Exception {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn").addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn").deploy();
        for (int i = 0; i < 4; ++i) {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).businessKey(i + "").create();
        }
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY_2).businessKey("1").create();
    }

    @After
    public void tearDown() throws Exception {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    private void verifyQueryResults(CaseExecutionQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    protected void verifyQueryWithOrdering(CaseExecutionQuery query, int countExpected, TestOrderingUtil.NullTolerantComparator<CaseExecution> expectedOrdering) {
        this.verifyQueryResults(query, countExpected);
        TestOrderingUtil.verifySorting(query.list(), expectedOrdering);
    }

    private void verifySingleResultFails(CaseExecutionQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryWithoutQueryParameter() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        this.verifyQueryResults(query, 11);
    }

    @Test
    public void testQueryByCaseDefinitionKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 8);
        query.caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).singleResult()).getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 8);
        caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult()).getId();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCaseInstaceId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        List caseInstances = this.caseService.createCaseInstanceQuery().caseDefinitionKey(CASE_DEFINITION_KEY).list();
        for (CaseInstance caseInstance : caseInstances) {
            query.caseInstanceId(caseInstance.getId());
            this.verifyQueryResults(query, 2);
        }
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult();
        query.caseInstanceId(instance.getId());
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByInvalidCaseInstanceId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCaseInstanceBusinessKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceBusinessKey("0");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByInvalidCaseInstanceBusinessKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceBusinessKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKey(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCaseInstanceBusinessKeyAndCaseDefinitionKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceBusinessKey("0").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("2").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("3").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByCaseExecutionId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        List executions = this.caseService.createCaseExecutionQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).list();
        for (CaseExecution execution : executions) {
            query.caseExecutionId(execution.getId());
            this.verifyQueryResults(query, 1);
        }
    }

    @Test
    public void testQueryByInvalidCaseExecutionId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseExecutionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseExecutionId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByActivityId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.activityId("PI_HumanTask_1");
        this.verifyQueryResults(query, 5);
        query.activityId("PI_HumanTask_2");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidActivityId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.activityId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.activityId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneMilestoneCase.cmmn"})
    @Test
    public void testQueryByAvailable() {
        this.caseService.withCaseDefinitionByKey("oneMilestoneCase").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.available();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByEnabled() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.enabled();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByActive() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.active();
        this.verifyQueryResults(query, 9);
    }

    @Test
    public void testQueryByDisabled() {
        List caseExecutions = this.caseService.createCaseExecutionQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).activityId("PI_HumanTask_1").list();
        for (CaseExecution caseExecution : caseExecutions) {
            this.caseService.withCaseExecution(caseExecution.getId()).disable();
        }
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.disabled();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByNullVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByStringVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByShortVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableValueEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByShortVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueNotEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        Date before = new Date(now.getTime() - 100000L);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueNotEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableValueNotEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueNotEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueGreaterThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueGreaterThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableGreaterThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueGreaterThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueGreaterThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueGreaterThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableGreaterThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueLessThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueLessThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableLessThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueLessThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueLessThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThanOrEqual("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueLessThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableLessThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLike("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByNullCaseInstanceVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByStringCaseInstanceVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByBooleanCaseInstanceVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByShortCaseInstanceVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByIntegerCaseInstanceVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByLongCaseInstanceVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDateCaseInstanceVariableValueEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDoubleCaseInstanceVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableCaseInstanceVariableValueEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringCaseInstanceVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByBooleanCaseInstanceVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByShortCaseInstanceVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByIntegerCaseInstanceVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByLongCaseInstanceVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDateCaseInstanceVariableValueNotEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        Date before = new Date(now.getTime() - 100000L);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDoubleCaseInstanceVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueNotEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableCaseInstanceVariableValueNotEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullCaseInstanceVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringCaseInstanceVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortCaseInstanceVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByLongCaseInstanceVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDateCaseInstanceVariableValueGreaterThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableCaseInstanceVariableGreaterThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aShortValue", (Object)122);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByLongCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDateCaseInstanceVariableValueGreaterThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThanOrEqual("aDateValue", (Object)before);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableCaseInstanceVariableGreaterThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullCaseInstanceVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringCaseInstanceVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByBooleanCaseInstanceVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortCaseInstanceVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByIntegerCaseInstanceVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByLongCaseInstanceVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDateCaseInstanceVariableValueLessThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDoubleCaseInstanceVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueLessThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableCaseInstanceVariableLessThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByBooleanCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aShortValue", (Object)124);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByIntegerCaseInstanceVariableValueLessThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByLongCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDateCaseInstanceVariableValueLessThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThanOrEqual("aDateValue", (Object)after);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByDoubleCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueLessThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableCaseInstanceVariableLessThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullCaseInstanceVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLike("aNullValue", null).list();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringCaseInstanceVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testCaseVariableValueEqualsNumber() throws Exception {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123L).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)12345L).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123.0).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", null).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)Variables.longValue(null)).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)"123").create();
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseExecutionQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseExecutionQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseExecutionQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseExecutionQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.caseService.createCaseExecutionQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseExecutionQuery().variableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.caseService.createCaseExecutionQuery().variableValueGreaterThan("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)5L, (long)this.caseService.createCaseExecutionQuery().variableValueGreaterThanOrEqual("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)0L, (long)this.caseService.createCaseExecutionQuery().variableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseExecutionQuery().variableValueLessThanOrEqual("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)8L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)8L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)8L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)8L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)2L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
        Assert.assertEquals((long)8L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)2L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueGreaterThan("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)10L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueGreaterThanOrEqual("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)0L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)8L, (long)this.caseService.createCaseExecutionQuery().caseInstanceVariableValueLessThanOrEqual("var", (Object)Variables.numberValue((Number)123)).count());
    }

    @Test
    public void testQuerySorting() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionId().asc();
        this.verifyQueryWithOrdering(query, 11, TestOrderingUtil.caseExecutionByDefinitionId());
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionKey().asc();
        this.verifyQueryWithOrdering(query, 11, TestOrderingUtil.caseExecutionByDefinitionKey(this.processEngine));
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseExecutionId().asc();
        this.verifyQueryWithOrdering(query, 11, TestOrderingUtil.caseExecutionById());
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionId().desc();
        this.verifyQueryWithOrdering(query, 11, TestOrderingUtil.inverted(TestOrderingUtil.caseExecutionByDefinitionId()));
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionKey().desc();
        this.verifyQueryWithOrdering(query, 11, TestOrderingUtil.inverted(TestOrderingUtil.caseExecutionByDefinitionKey(this.processEngine)));
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseExecutionId().desc();
        this.verifyQueryWithOrdering(query, 11, TestOrderingUtil.inverted(TestOrderingUtil.caseExecutionById()));
        query = this.caseService.createCaseExecutionQuery();
    }

    @Test
    public void testCaseExecutionProperties() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution task = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult();
        Assert.assertEquals((Object)"PI_HumanTask_1", (Object)task.getActivityId());
        Assert.assertEquals((Object)"A HumanTask", (Object)task.getActivityName());
        Assert.assertEquals((Object)caseDefinitionId, (Object)task.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstanceId, (Object)task.getParentId());
        Assert.assertEquals((Object)"humanTask", (Object)task.getActivityType());
        Assert.assertNotNull((Object)task.getActivityDescription());
        Assert.assertNotNull((Object)task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    @Test
    public void testQueryByRequired() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", true));
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().required();
        this.verifyQueryResults(query, 1);
        CaseExecution execution = (CaseExecution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertTrue((boolean)execution.isRequired());
    }

    @Test
    public void testNullBusinessKeyForChildExecutions() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY, "7890");
        List executions = this.caseService.createCaseExecutionQuery().caseInstanceBusinessKey("7890").list();
        for (CaseExecution e : executions) {
            if (((CaseExecutionEntity)e).isCaseInstanceExecution()) {
                Assert.assertEquals((Object)"7890", (Object)((CaseExecutionEntity)e).getBusinessKeyWithoutCascade());
                continue;
            }
            Assert.assertNull((Object)((CaseExecutionEntity)e).getBusinessKeyWithoutCascade());
        }
    }
}

