/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.test.api.variables.AbstractVariableIgnoreCaseTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ExecutionQueryVariableIgnoreCaseTest
extends AbstractVariableIgnoreCaseTest<ExecutionQueryImpl, Execution> {
    RepositoryService repositoryService;
    RuntimeService runtimeService;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").deploy();
        this.instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
    }

    @After
    public void tearDown() {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Override
    protected ExecutionQueryImpl createQuery() {
        return (ExecutionQueryImpl)this.runtimeService.createExecutionQuery();
    }

    @Override
    protected void assertThatTwoInstancesAreEqual(Execution one, Execution two) {
        Assertions.assertThat((String)one.getId()).isEqualTo((Object)two.getId());
    }

    @Test
    public void testProcessVariableNameEqualsIgnoreCase() {
        List eq = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueEquals("variableName", (Object)"variableValue").list();
        List eqNameLC = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List eqValueLC = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, this.instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, this.instance);
        Assertions.assertThat((List)eqValueLC).isEmpty();
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    public void testProcessVariableNameNotEqualsIgnoreCase() {
        List neq = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueNotEquals("variableName", (Object)"variableValue").list();
        List neqNameLC = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List neqValueNE = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueNotEquals("variableName", (Object)"nonExistent").list();
        List neqNameLCValueNE = ((ExecutionQueryImpl)this.queryNameIgnoreCase()).processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, this.instance);
        this.assertThatListContainsOnlyExpectedElement(neqNameLCValueNE, this.instance);
    }

    @Test
    public void testProcessVariableValueEqualsIgnoreCase() {
        List eq = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueEquals("variableName", (Object)"variableValue").list();
        List eqNameLC = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List eqValueLC = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, this.instance);
        Assertions.assertThat((List)eqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, this.instance);
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    public void testProcessVariableValueNotEqualsIgnoreCase() {
        List neq = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueNotEquals("variableName", (Object)"variableValue").list();
        List neqNameLC = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List neqValueNE = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueNotEquals("variableName", (Object)"nonExistent").list();
        List neqNameLCValueNE = ((ExecutionQueryImpl)this.queryValueIgnoreCase()).processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, this.instance);
        Assertions.assertThat((List)neqNameLCValueNE).isEmpty();
    }

    @Test
    public void testProcessVariableNameAndValueEqualsIgnoreCase() {
        List eq = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueEquals("variableName", (Object)"variableValue").list();
        List eqNameLC = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List eqValueLC = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List eqValueNE = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueEquals("variableName", (Object)"nonExistent").list();
        List eqNameValueLC = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List eqNameLCValueNE = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        this.assertThatListContainsOnlyExpectedElement(eq, this.instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, this.instance);
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, this.instance);
        Assertions.assertThat((List)eqValueNE).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqNameValueLC, this.instance);
        Assertions.assertThat((List)eqNameLCValueNE).isEmpty();
    }

    @Test
    public void testProcessVariableNameAndValueNotEqualsIgnoreCase() {
        List neq = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueNotEquals("variableName", (Object)"variableValue").list();
        List neqNameLC = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List neqValueLC = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueNotEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List neqValueNE = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueNotEquals("variableName", (Object)"nonExistent").list();
        List neqNameValueLC = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List neqNameLCValueNE = ((ExecutionQueryImpl)this.queryNameValueIgnoreCase()).processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        Assertions.assertThat((List)neqValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, this.instance);
        Assertions.assertThat((List)neqNameValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqNameLCValueNE, this.instance);
    }
}

