/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.el;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.el.ExecutionTestVariable;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionManagerTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testMethodExpressions() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("aString", "abcdefgh");
        this.runtimeService.startProcessInstanceByKey("methodExpressionProcess", vars);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("methodExpressionProcess").count());
    }

    @Deployment
    @Test
    public void testExecutionAvailable() {
        HashMap<String, ExecutionTestVariable> vars = new HashMap<String, ExecutionTestVariable>();
        vars.put("myVar", new ExecutionTestVariable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testExecutionAvailableProcess", vars);
        String value = (String)this.runtimeService.getVariable(processInstance.getId(), "testVar");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"myValue", (Object)value);
    }

    @Deployment
    @Test
    public void testAuthenticatedUserIdAvailable() {
        try {
            this.identityService.setAuthenticatedUserId("frederik");
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testAuthenticatedUserIdAvailableProcess");
            String value = (String)this.runtimeService.getVariable(processInstance.getId(), "theUser");
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)"frederik", (Object)value);
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Deployment
    @Test
    public void testResolvesVariablesFromDifferentScopes() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("assignee", "michael");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"michael", (Object)task.getAssignee());
        variables.put("assignee", "johnny");
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(secondInstance.getId()).singleResult();
        Assert.assertEquals((Object)"johnny", (Object)task.getAssignee());
    }

    @Deployment
    @RequiredHistoryLevel(value="full")
    @Test
    public void testSetVariableByExpressionFromListener() {
        this.runtimeService.startProcessInstanceByKey("fieldInjectionTest", (Map)Variables.putValue((String)"myCounter", (Object)5));
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myCounter", (Object)6).count());
    }
}

