/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.error.BpmnErrorBean;
import org.camunda.bpm.engine.test.bpmn.event.error.ThrowErrorDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BoundaryErrorEventTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.identityService.setAuthenticatedUserId("kermit");
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
    }

    @Deployment
    @Test
    public void testCatchErrorOnEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("boundaryErrorOnEmbeddedSubprocess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"subprocessTask", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task after catching the error", (Object)task.getName());
    }

    @Test
    public void testThrowErrorWithoutErrorCode() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testThrowErrorWithoutErrorCode.bpmn20.xml").deploy();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("'errorCode' is mandatory on errors referenced by throwing error event definitions", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"theEnd");
        }
    }

    @Test
    public void testThrowErrorWithEmptyErrorCode() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testThrowErrorWithEmptyErrorCode.bpmn20.xml").deploy();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("'errorCode' is mandatory on errors referenced by throwing error event definitions", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"theEnd");
        }
    }

    @Deployment
    @Test
    public void testCatchErrorOnEmbeddedSubprocessWithEmptyErrorCode() {
        this.testCatchErrorOnEmbeddedSubprocess();
    }

    @Deployment
    @Test
    public void testCatchErrorOnEmbeddedSubprocessWithoutErrorCode() {
        this.testCatchErrorOnEmbeddedSubprocess();
    }

    @Deployment
    @Test
    public void testCatchErrorOfInnerSubprocessOnOuterSubprocess() {
        this.runtimeService.startProcessInstanceByKey("boundaryErrorTest");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"Inner subprocess task 1", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Inner subprocess task 2", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = this.taskService.createTaskQuery().list();
        Task taskAfterError = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task outside subprocess", (Object)taskAfterError.getName());
    }

    @Deployment
    @Test
    public void testCatchErrorInConcurrentEmbeddedSubprocesses() {
        this.assertErrorCaughtInConcurrentEmbeddedSubprocesses("boundaryEventTestConcurrentSubprocesses");
    }

    @Deployment
    @Test
    public void testCatchErrorInConcurrentEmbeddedSubprocessesThrownByScriptTask() {
        this.assertErrorCaughtInConcurrentEmbeddedSubprocesses("catchErrorInConcurrentEmbeddedSubprocessesThrownByScriptTask");
    }

    private void assertErrorCaughtInConcurrentEmbeddedSubprocesses(String processDefinitionKey) {
        String procId = this.runtimeService.startProcessInstanceByKey(processDefinitionKey).getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"task A", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"task B", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task D", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
        procId = this.runtimeService.startProcessInstanceByKey(processDefinitionKey).getId();
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"task A", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"task B", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"task A", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"task C", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task A", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task D", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testDeeplyNestedErrorThrown() {
        String procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Nested task", (Object)task.getName());
        this.taskService.complete(task.getId(), CollectionUtil.singletonMap((String)"input", (Object)1));
        this.testRule.assertProcessEnded(procId);
        procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown").getId();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Nested task", (Object)task.getName());
        this.taskService.complete(task.getId(), CollectionUtil.singletonMap((String)"input", (Object)2));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task after catch", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testDeeplyNestedErrorThrownOnlyAutomaticSteps() {
        HistoricProcessInstance hip;
        String procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown", CollectionUtil.singletonMap((String)"input", (Object)1)).getId();
        this.testRule.assertProcessEnded(procId);
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procId).singleResult();
            Assert.assertEquals((Object)"processEnd1", (Object)hip.getEndActivityId());
        }
        procId = this.runtimeService.startProcessInstanceByKey("deeplyNestedErrorThrown", CollectionUtil.singletonMap((String)"input", (Object)1)).getId();
        this.testRule.assertProcessEnded(procId);
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            hip = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procId).singleResult();
            Assert.assertEquals((Object)"processEnd1", (Object)hip.getEndActivityId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    @Test
    public void testCatchErrorOnCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnCallActivity").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    public void FAILING_testCatchErrorOnCallActivityShouldEndCalledProcessProperly() {
        this.runtimeService.startProcessInstanceByKey("catchErrorOnCallActivity").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Task", (Object)task.getName());
        HistoricProcessInstance historicSubProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("simpleSubProcess").singleResult();
        Assert.assertNotNull((Object)historicSubProcessInstance);
        Assert.assertNull((Object)historicSubProcessInstance.getDeleteReason());
        Assert.assertEquals((Object)"theEnd", (Object)historicSubProcessInstance.getEndActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    @Test
    public void testUncaughtError() {
        this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        try {
            this.taskService.complete(task.getId());
        }
        catch (BpmnError e) {
            this.testRule.assertTextPresent("No catching boundary event found for error with errorCode 'myError', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testUncaughtErrorOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    @Test
    public void testUncaughtErrorOnCallActivity() {
        this.runtimeService.startProcessInstanceByKey("uncaughtErrorOnCallActivity");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        try {
            this.taskService.complete(task.getId());
        }
        catch (BpmnError e) {
            this.testRule.assertTextPresent("No catching boundary event found for error with errorCode 'myError', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByCallActivityOnSubprocess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByCallActivityOnSubprocess() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnSubprocess").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByCallActivityOnCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess2ndLevel.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.subprocess.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByCallActivityOnCallActivity() throws InterruptedException {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnCallActivity2ndLevel").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorOnParallelMultiInstance() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnParallelMi").getId();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("throwError", false);
        this.taskService.complete(((Task)tasks.get(2)).getId(), vars);
        this.taskService.complete(((Task)tasks.get(3)).getId(), vars);
        vars.put("throwError", true);
        this.taskService.complete(((Task)tasks.get(1)).getId(), vars);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorOnSequentialMultiInstance() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorOnSequentialMi").getId();
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("throwError", false);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId(), vars);
        vars.put("throwError", true);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId(), vars);
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownBySignallableActivityBehaviour() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownBySignallableActivityBehaviour").getId();
        Assert.assertNotNull((String)"Didn't get a process id from runtime service", (Object)procId);
        ActivityInstance processActivityInstance = this.runtimeService.getActivityInstance(procId);
        ActivityInstance serviceTask = processActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((String)"Expected the service task to be active after starting the process", (Object)"serviceTask", (Object)serviceTask.getActivityId());
        this.runtimeService.signal(serviceTask.getExecutionIds()[0]);
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateOnServiceTask() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTask").getId();
        this.assertThatErrorHasBeenCaught(procId);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("exceptionType", true);
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateOnServiceTaskNotCancelActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTaskNotCancelActiviti").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateOnServiceTaskWithErrorCode() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnServiceTaskWithErrorCode").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateOnEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("exceptionType", true);
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnEmbeddedSubProcess", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateOnEmbeddedSubProcessInduction() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnEmbeddedSubProcessInduction").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByJavaDelegateOnCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnCallActivity-parent").getId();
        this.assertThatErrorHasBeenCaught(procId);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("exceptionType", true);
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnCallActivity-parent", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    @Test
    public void testUncaughtErrorThrownByJavaDelegateOnServiceTask() {
        try {
            this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnCallActivity-child");
        }
        catch (BpmnError e) {
            this.testRule.assertTextPresent("No catching boundary event found for error with errorCode '23', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalMethodOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment
    @Test
    public void testCatchExceptionExpressionThrownByFollowUpTask() {
        try {
            Map<String, Object> vars = ThrowErrorDelegate.throwException();
            this.runtimeService.startProcessInstanceByKey("testProcess", vars).getId();
            Assert.fail((String)"should fail and not catch the error on the first task");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Deployment
    @Test
    public void testCatchExceptionClassDelegateThrownByFollowUpTask() {
        try {
            Map<String, Object> vars = ThrowErrorDelegate.throwException();
            this.runtimeService.startProcessInstanceByKey("testProcess", vars).getId();
            Assert.fail((String)"should fail");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Deployment
    @Test
    public void testCatchExceptionExpressionThrownByFollowUpScopeTask() {
        try {
            Map<String, Object> vars = ThrowErrorDelegate.throwException();
            this.runtimeService.startProcessInstanceByKey("testProcess", vars).getId();
            Assert.fail((String)"should fail and not catch the error on the first task");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalMethodOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testUncaughtErrorThrownByJavaDelegateOnCallActivity-parent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    @Test
    public void testUncaughtErrorThrownByJavaDelegateOnCallActivity() {
        try {
            this.runtimeService.startProcessInstanceByKey("uncaughtErrorThrownByJavaDelegateOnCallActivity-parent");
        }
        catch (BpmnError e) {
            this.testRule.assertTextPresent("No catching boundary event found for error with errorCode '23', neither in same process nor in parent process", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskSequential() {
        HashMap<String, Constable> variables = new HashMap<String, Constable>();
        variables.put("executionsBeforeError", Integer.valueOf(2));
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskSequential", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
        variables.put("executionsBeforeError", Integer.valueOf(2));
        variables.put("exceptionType", Boolean.valueOf(true));
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskSequential", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskParallel() {
        HashMap<String, Constable> variables = new HashMap<String, Constable>();
        variables.put("executionsBeforeError", Integer.valueOf(2));
        String procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskParallel", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
        variables.put("executionsBeforeError", Integer.valueOf(2));
        variables.put("exceptionType", Boolean.valueOf(true));
        procId = this.runtimeService.startProcessInstanceByKey("catchErrorThrownByJavaDelegateOnMultiInstanceServiceTaskParallel", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testErrorThrownByJavaDelegateNotCaughtByOtherEventType() {
        String procId = this.runtimeService.startProcessInstanceByKey("testErrorThrownByJavaDelegateNotCaughtByOtherEventType").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    private void assertThatErrorHasBeenCaught(String procId) {
        Assert.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    private void assertThatExceptionHasBeenCaught(String procId) {
        Assert.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Exception Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testConcurrentExecutionsInterruptedOnDestroyScope() {
        this.runtimeService.startProcessInstanceByKey("process");
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByExpressionOnServiceTask() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByExpressionOnServiceTask", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByDelegateExpressionOnServiceTask() {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByDelegateExpressionOnServiceTask", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
        variables.put("exceptionType", Boolean.valueOf(true));
        procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByDelegateExpressionOnServiceTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByJavaDelegateProvidedByDelegateExpressionOnServiceTask() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchErrorThrownByJavaDelegateProvidedByDelegateExpressionOnServiceTask", variables).getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchExceptionThrownByExpressionOnServiceTask() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchExceptionThrownByExpressionOnServiceTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchExceptionThrownByScriptTask() {
        HashMap variables = new HashMap();
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchExceptionThrownByScriptTask", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchSpecializedExceptionThrownByDelegate() {
        HashMap<String, BpmnErrorBean> variables = new HashMap<String, BpmnErrorBean>();
        variables.put("bpmnErrorBean", new BpmnErrorBean());
        String procId = this.runtimeService.startProcessInstanceByKey("testCatchSpecializedExceptionThrownByDelegate", variables).getId();
        this.assertThatExceptionHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testUncaughtRuntimeException() {
        try {
            this.runtimeService.startProcessInstanceByKey("testUncaughtRuntimeException");
            Assert.fail((String)"error should not be caught");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"This should not be caught!", (Object)e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testUncaughtBusinessExceptionWrongErrorCode() {
        try {
            this.runtimeService.startProcessInstanceByKey("testUncaughtBusinessExceptionWrongErrorCode");
            Assert.fail((String)"error should not be caught");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"couldn't execute activity <serviceTask id=\"serviceTask\" ...>: Business Exception", (Object)e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testCatchErrorOnSubprocessThrownByNonInterruptingEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        EventSubscription messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("message", messageSubscription.getExecutionId());
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("afterBoundaryTask").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Task task = (Task)this.taskService.createTaskQuery().executionId(taskExecution.getId()).singleResult();
        Assert.assertNotNull((Object)task);
    }

    @Deployment
    @Test
    public void testCatchErrorOnSubprocessThrownByInterruptingEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        EventSubscription messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("message", messageSubscription.getExecutionId());
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("afterBoundaryTask").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Task task = (Task)this.taskService.createTaskQuery().executionId(taskExecution.getId()).singleResult();
        Assert.assertNotNull((Object)task);
    }

    @Deployment
    @Test
    public void testCatchErrorOnSubprocessThrownByNestedEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        EventSubscription messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("outerMessage", messageSubscription.getExecutionId());
        messageSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        this.runtimeService.messageEventReceived("innerMessage", messageSubscription.getExecutionId());
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("afterBoundaryTask").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Task task = (Task)this.taskService.createTaskQuery().executionId(taskExecution.getId()).singleResult();
        Assert.assertNotNull((Object)task);
    }

    @Deployment
    @Test
    public void testCatchErrorOnSubprocessSetsErrorVariables() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorVariable";
        String errorCode = "error1";
        this.checkErrorVariable(variableName, errorCode);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorProcess.bpmn", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByCallActivityOnSubprocessSetsErrorCodeVariable.bpmn"})
    @Test
    public void testCatchErrorThrownByCallActivityOnSubprocessSetsErrorVariables() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorVariable";
        String errorCode = "error";
        this.checkErrorVariable(variableName, errorCode);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByMultiInstanceSubProcessSetsErrorCodeVariable.bpmn"})
    @Test
    public void testCatchErrorThrownByMultiInstanceSubProcessSetsErrorVariables() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorVariable";
        String errorCode = "error";
        this.checkErrorVariable(variableName, errorCode);
    }

    private void checkErrorVariable(String variableName, Object expectedValue) {
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assert.assertThat((Object)errorVariable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)errorVariable.getValue(), (Matcher)CoreMatchers.is((Object)expectedValue));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchBpmnErrorThrownByJavaDelegateInCallActivityOnSubprocessSetsErrorVariables.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithThrownError.bpmn"})
    @Test
    public void testCatchBpmnErrorThrownByJavaDelegateInCallActivityOnSubprocessSetsErrorVariables() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        String variableName = "errorCode";
        String errorCode = "errorCode";
        this.checkErrorVariable(variableName, errorCode);
        this.checkErrorVariable("errorMessageVariable", "ouch!");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/reviewSalesLead.bpmn20.xml"})
    @Test
    public void testReviewSalesLeadProcess() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("details", "very interesting");
        variables.put("customerName", "Alfresco");
        String procId = this.runtimeService.startProcessInstanceByKey("reviewSaledLead", variables).getId();
        Task task = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
        Assert.assertEquals((Object)"Provide new sales lead", (Object)task.getName());
        this.taskService.complete(task.getId());
        Task ratingTask = (Task)this.taskService.createTaskQuery().taskCandidateGroup("accountancy").singleResult();
        Assert.assertEquals((Object)"Review customer rating", (Object)ratingTask.getName());
        Task profitabilityTask = (Task)this.taskService.createTaskQuery().taskCandidateGroup("management").singleResult();
        Assert.assertEquals((Object)"Review profitability", (Object)profitabilityTask.getName());
        variables = new HashMap();
        variables.put("notEnoughInformation", true);
        this.taskService.complete(profitabilityTask.getId(), variables);
        Task provideDetailsTask = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
        Assert.assertEquals((Object)"Provide additional details", (Object)provideDetailsTask.getName());
        this.taskService.complete(provideDetailsTask.getId());
        List reviewTasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((Object)"Review customer rating", (Object)((Task)reviewTasks.get(0)).getName());
        Assert.assertEquals((Object)"Review profitability", (Object)((Task)reviewTasks.get(1)).getName());
        this.taskService.complete(((Task)reviewTasks.get(0)).getId());
        variables.put("notEnoughInformation", false);
        this.taskService.complete(((Task)reviewTasks.get(1)).getId(), variables);
        this.testRule.assertProcessEnded(procId);
    }
}

