/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.shell;

import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShellTaskTest
extends PluggableProcessEngineTest {
    OsType osType;

    OsType getSystemOsType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            return OsType.WINDOWS;
        }
        if (osName.indexOf("mac") >= 0) {
            return OsType.MAC;
        }
        if (osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0) {
            return OsType.LINUX;
        }
        if (osName.indexOf("sunos") >= 0) {
            return OsType.SOLARIS;
        }
        return OsType.UNKOWN;
    }

    @Before
    public void setUp() throws Exception {
        this.osType = this.getSystemOsType();
    }

    @Test
    public void testOsDetection() throws Exception {
        Assert.assertTrue((this.osType != OsType.UNKOWN ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testEchoShellWindows() {
        if (this.osType == OsType.WINDOWS) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("echoShellWindows");
            String st = (String)this.runtimeService.getVariable(pi.getId(), "resultVar");
            Assert.assertNotNull((Object)st);
            Assert.assertTrue((boolean)st.startsWith("EchoTest"));
        }
    }

    @Deployment
    @Test
    public void testEchoShellLinux() {
        if (this.osType == OsType.LINUX) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("echoShellLinux");
            String st = (String)this.runtimeService.getVariable(pi.getId(), "resultVar");
            Assert.assertNotNull((Object)st);
            Assert.assertTrue((boolean)st.startsWith("EchoTest"));
        }
    }

    @Deployment
    @Test
    public void testEchoShellMac() {
        if (this.osType == OsType.MAC) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("echoShellMac");
            String st = (String)this.runtimeService.getVariable(pi.getId(), "resultVar");
            Assert.assertNotNull((Object)st);
            Assert.assertTrue((boolean)st.startsWith("EchoTest"));
        }
    }

    static enum OsType {
        LINUX,
        WINDOWS,
        MAC,
        SOLARIS,
        UNKOWN;

    }
}

