/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractTaskListenerTest {
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Before
    public void resetListeners() {
        RecorderTaskListener.clear();
    }

    protected void createAndDeployModelWithTaskEventsRecorderOnUserTask(String ... eventTypes) {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(eventTypes, null, null, null);
        this.testRule.deploy(model);
    }

    protected void createAndDeployModelWithTaskEventsRecorderOnUserTaskWithAssignee(String assignee, String ... eventTypes) {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(eventTypes, assignee, null, null);
        this.testRule.deploy(model);
    }

    protected BpmnModelInstance createModelWithTaskEventsRecorderOnAssignedUserTask(String[] eventTypes, String assignee, String customListenerEventType, Class<? extends TaskListener> taskListenerClass) {
        UserTaskBuilder userTaskModelBuilder = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task");
        if (assignee != null) {
            userTaskModelBuilder.camundaAssignee("kermit");
        }
        for (String eventType : eventTypes) {
            userTaskModelBuilder.camundaTaskListenerClass(eventType, RecorderTaskListener.class);
        }
        if (taskListenerClass != null) {
            userTaskModelBuilder.camundaTaskListenerClass(customListenerEventType, taskListenerClass);
        }
        BpmnModelInstance model = userTaskModelBuilder.endEvent().done();
        return model;
    }
}

