/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.deploy;

import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DeploymentTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setJdbcUrl("jdbc:h2:mem:DeploymentTest-HistoryLevelNone;DB_CLOSE_DELAY=1000");
        configuration.setDatabaseSchemaUpdate("create-drop");
        configuration.setHistoryLevel(HistoryLevel.HISTORY_LEVEL_NONE);
        configuration.setDbHistoryUsed(false);
    });
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    public void shouldDeleteDeployment() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        DeploymentWithDefinitions deployment = this.engineRule.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", instance).deployWithResult();
        this.engineRule.getRepositoryService().deleteDeployment(deployment.getId(), true);
        long count = this.engineRule.getRepositoryService().createDeploymentQuery().count();
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldDeleteDeploymentWithRunningInstance() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("testTask").endEvent().done();
        DeploymentWithDefinitions deployment = this.engineRule.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", instance).deployWithResult();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Assert.assertThat((Object)this.engineRule.getRuntimeService().createProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        this.engineRule.getRepositoryService().deleteDeployment(deployment.getId(), true);
        long count = this.engineRule.getRepositoryService().createDeploymentQuery().count();
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)0L));
    }
}

