/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@RequiredHistoryLevel(value="audit")
public class HistoricTaskInstanceQueryOrTest {
    @Rule
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected RepositoryService repositoryService;
    protected FilterService filterService;

    @Before
    public void init() {
        this.historyService = this.processEngineRule.getHistoryService();
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
        this.caseService = this.processEngineRule.getCaseService();
        this.repositoryService = this.processEngineRule.getRepositoryService();
        this.filterService = this.processEngineRule.getFilterService();
    }

    @After
    public void tearDown() {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        for (HistoricTaskInstance task : this.historyService.createHistoricTaskInstanceQuery().list()) {
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Test
    public void shouldThrowExceptionByMissingStartOr() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set endOr() before or()");
        this.historyService.createHistoricTaskInstanceQuery().or().endOr().endOr();
    }

    @Test
    public void shouldThrowExceptionByNesting() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set or() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().or().endOr().endOr().or().endOr();
    }

    @Test
    public void shouldThrowExceptionByWithCandidateGroupsApplied() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set withCandidateGroups() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().withCandidateGroups().endOr();
    }

    @Test
    public void shouldThrowExceptionByWithoutCandidateGroupsApplied() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set withoutCandidateGroups() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().withoutCandidateGroups().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTenantId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTenantId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTenantId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricActivityInstanceId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByHistoricActivityInstanceId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricActivityInstanceId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByProcessDefinitionId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByProcessDefinitionId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByProcessInstanceId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByProcessInstanceId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByExecutionId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByExecutionId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByExecutionId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricTaskInstanceDuration() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByHistoricTaskInstanceDuration() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricTaskInstanceDuration().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricTaskInstanceEndTime() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByHistoricTaskInstanceEndTime() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricTaskInstanceEndTime().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByHistoricActivityInstanceStartTime() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByHistoricTaskInstanceEndTime() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByHistoricTaskInstanceEndTime().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskName() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskName() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskName().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskDescription() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskDescription() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskDescription().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskAssignee() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskAssignee() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskAssignee().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskOwner() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskOwner() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskOwner().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskDueDate() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskDueDate() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskDueDate().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskFollowUpDate() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskFollowUpDate() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskFollowUpDate().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByDeleteReason() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByDeleteReason() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByDeleteReason().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskDefinitionKey() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskDefinitionKey() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskDefinitionKey().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByTaskPriority() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByTaskPriority() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByTaskPriority().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByCaseDefinitionId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByCaseDefinitionId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByCaseDefinitionId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByCaseInstanceId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByCaseInstanceId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByCaseInstanceId().endOr();
    }

    @Test
    public void shouldThrowExceptionOnOrderByCaseExecutionId() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid query usage: cannot set orderByCaseExecutionId() within 'or' query");
        this.historyService.createHistoricTaskInstanceQuery().or().orderByCaseExecutionId().endOr();
    }

    @Test
    public void shouldReturnHistoricTasksWithEmptyOrQuery() {
        this.taskService.saveTask(this.taskService.newTask());
        this.taskService.saveTask(this.taskService.newTask());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWithTaskNameOrTaskDescription() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWithMultipleOrCriteria() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setPriority(5);
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setOwner("aTaskOwner");
        this.taskService.saveTask(task5);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").taskId(task3.getId()).taskPriority(Integer.valueOf(5)).taskOwner("aTaskOwner").endOr().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksFilteredByMultipleOrAndCriteria() {
        Task task1 = this.taskService.newTask();
        task1.setPriority(4);
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("aTaskName");
        task2.setOwner("aTaskOwner");
        task2.setAssignee("aTaskAssignee");
        task2.setPriority(4);
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("aTaskName");
        task3.setOwner("aTaskOwner");
        task3.setAssignee("aTaskAssignee");
        task3.setPriority(4);
        task3.setDescription("aTaskDescription");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setOwner("aTaskOwner");
        task4.setAssignee("aTaskAssignee");
        task4.setPriority(4);
        task4.setDescription("aTaskDescription");
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setDescription("aTaskDescription");
        task5.setOwner("aTaskOwner");
        this.taskService.saveTask(task5);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").taskId(task3.getId()).endOr().taskOwner("aTaskOwner").taskPriority(Integer.valueOf(4)).taskAssignee("aTaskAssignee").list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksFilteredByMultipleOrQueries() {
        Task task1 = this.taskService.newTask();
        task1.setName("aTaskName");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("aTaskName");
        task2.setDescription("aTaskDescription");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("aTaskName");
        task3.setDescription("aTaskDescription");
        task3.setOwner("aTaskOwner");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setName("aTaskName");
        task4.setDescription("aTaskDescription");
        task4.setOwner("aTaskOwner");
        task4.setAssignee("aTaskAssignee");
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setName("aTaskName");
        task5.setDescription("aTaskDescription");
        task5.setOwner("aTaskOwner");
        task5.setAssignee("aTaskAssignee");
        task5.setPriority(4);
        this.taskService.saveTask(task5);
        Task task6 = this.taskService.newTask();
        task6.setName("aTaskName");
        task6.setDescription("aTaskDescription");
        task6.setOwner("aTaskOwner");
        task6.setAssignee("aTaskAssignee");
        task6.setPriority(4);
        this.taskService.saveTask(task6);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("aTaskName").taskDescription("aTaskDescription").endOr().or().taskName("aTaskName").taskDescription("aTaskDescription").taskAssignee("aTaskAssignee").endOr().or().taskName("aTaskName").taskDescription("aTaskDescription").taskOwner("aTaskOwner").taskAssignee("aTaskAssignee").endOr().or().taskAssignee("aTaskAssignee").taskPriority(Integer.valueOf(4)).endOr().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWhereSameCriterionWasAppliedThreeTimesInOneQuery() {
        Task task1 = this.taskService.newTask();
        task1.setName("task1");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("task2");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("task3");
        this.taskService.saveTask(task3);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskName("task1").taskName("task2").taskName("task3").endOr().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricTasksWithActivityInstanceIdInOrTaskId() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        String activityInstanceId = this.runtimeService.getActivityInstance(processInstance1.getId()).getChildActivityInstances()[0].getId();
        Task task2 = this.taskService.newTask();
        this.taskService.saveTask(task2);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().activityInstanceIdIn(new String[]{activityInstanceId}).taskId(task2.getId()).endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldTestDueDateCombinations() throws ParseException {
        HashMap<String, Date> dates = this.createFollowUpAndDueDateTasks();
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueBefore(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueBefore(dates.get("oneHourAgo")).taskDueAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueBefore(dates.get("oneHourLater")).taskDueAfter(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskDueDate(dates.get("date")).taskDueBefore(dates.get("oneHourAgo")).taskDueAfter(dates.get("oneHourLater")).endOr().count());
    }

    @Test
    public void shouldTestFollowUpDateCombinations() throws ParseException {
        HashMap<String, Date> dates = this.createFollowUpAndDueDateTasks();
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpDate(dates.get("date")).taskFollowUpBefore(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpDate(dates.get("date")).taskFollowUpAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpBefore(dates.get("oneHourAgo")).taskFollowUpAfter(dates.get("oneHourLater")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpBefore(dates.get("oneHourLater")).taskFollowUpAfter(dates.get("oneHourAgo")).endOr().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().or().taskFollowUpDate(dates.get("date")).taskFollowUpBefore(dates.get("oneHourAgo")).taskFollowUpAfter(dates.get("oneHourLater")).endOr().count());
        this.taskService.saveTask(this.taskService.newTask());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
    }

    @Test
    public void shouldQueryStartedBeforeOrAfter() {
        Date dateOne = new Date(1363607000000L);
        ClockUtil.setCurrentTime((Date)dateOne);
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        Date dateTwo = new Date(dateOne.getTime() + 7000000L);
        ClockUtil.setCurrentTime((Date)dateTwo);
        Task taskTwo = this.taskService.newTask();
        this.taskService.saveTask(taskTwo);
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().startedBefore(new Date(dateOne.getTime() + 1000L)).startedAfter(new Date(dateTwo.getTime() - 1000L)).endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryStandaloneOrEmbeddedTaskByProcessDefinitionKey() {
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskId(taskOne.getId()).processDefinitionKey("oneTaskProcess").endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryStandaloneOrEmbeddedTaskByProcessInstanceId() {
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "aBusinessKey");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskId(taskOne.getId()).processInstanceBusinessKey("aBusinessKey").endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void shouldQueryStandaloneOrEmbeddedTaskByCaseDefinitionId() {
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().taskId(taskOne.getId()).caseDefinitionKey("oneTaskCase").endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    @Test
    public void shouldQueryFinishedBeforeOrAfter() {
        Date dateOne = new Date(1363607000000L);
        ClockUtil.setCurrentTime((Date)dateOne);
        Task taskOne = this.taskService.newTask();
        this.taskService.saveTask(taskOne);
        this.taskService.complete(taskOne.getId());
        Date dateTwo = new Date(dateOne.getTime() + 7000000L);
        ClockUtil.setCurrentTime((Date)dateTwo);
        Task taskTwo = this.taskService.newTask();
        this.taskService.saveTask(taskTwo);
        this.taskService.complete(taskTwo.getId());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().or().finishedBefore(new Date(dateOne.getTime() + 1000L)).finishedAfter(new Date(dateTwo.getTime() - 1000L)).endOr().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
    }

    public HashMap<String, Date> createFollowUpAndDueDateTasks() throws ParseException {
        final Date date = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("27/07/2017 01:12:13");
        final Date oneHourAgo = new Date(date.getTime() - 3600000L);
        final Date oneHourLater = new Date(date.getTime() + 3600000L);
        Task taskDueBefore = this.taskService.newTask();
        taskDueBefore.setFollowUpDate(new Date(oneHourAgo.getTime() - 1000L));
        taskDueBefore.setDueDate(new Date(oneHourAgo.getTime() - 1000L));
        this.taskService.saveTask(taskDueBefore);
        Task taskDueDate = this.taskService.newTask();
        taskDueDate.setFollowUpDate(date);
        taskDueDate.setDueDate(date);
        this.taskService.saveTask(taskDueDate);
        Task taskDueAfter = this.taskService.newTask();
        taskDueAfter.setFollowUpDate(new Date(oneHourLater.getTime() + 1000L));
        taskDueAfter.setDueDate(new Date(oneHourLater.getTime() + 1000L));
        this.taskService.saveTask(taskDueAfter);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        return new HashMap<String, Date>(){
            {
                this.put("date", date);
                this.put("oneHourAgo", oneHourAgo);
                this.put("oneHourLater", oneHourLater);
            }
        };
    }
}

