/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.telemetry;

import camundajar.impl.com.google.gson.Gson;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.camunda.bpm.engine.impl.telemetry.dto.Command;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.dto.Internals;
import org.camunda.bpm.engine.impl.telemetry.dto.Metric;
import org.camunda.bpm.engine.impl.telemetry.dto.Product;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class TelemetryTaskWorkerMetricsTest {
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8083/pings";
    private static final String TELEMETRY_ENDPOINT_PATH = "/pings";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setJdbcUrl("jdbc:h2:mem:TelemetryTaskWorkerMetricsTest").setDatabaseSchemaUpdate("create-drop").setHistoryLevel(HistoryLevel.HISTORY_LEVEL_NONE));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);
    @ClassRule
    public static WireMockRule wireMockRule = new WireMockRule(8083);
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.configuration.getManagementService();
        this.runtimeService = this.configuration.getRuntimeService();
        this.taskService = this.configuration.getTaskService();
        this.clearMetrics();
        this.configuration.setTelemetryRegistry(new TelemetryRegistry());
    }

    @After
    public void tearDown() {
        this.managementService.toggleTelemetry(false);
        this.clearMetrics();
    }

    protected void clearMetrics() {
        Collection meters = this.configuration.getMetricsRegistry().getDbMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotSendTelemetryWithTaskWorkersMetrics() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 3; ++i) {
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
            String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult()).getId();
            this.taskService.setAssignee(taskId, "user" + i);
        }
        Data data = this.adjustData(this.configuration.getTelemetryData(), 3, 0, 6, 0);
        String requestBody = new Gson().toJson((Object)data);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        new TelemetryReporter(this.configuration.getCommandExecutorSchemaOperations(), TELEMETRY_ENDPOINT, 0, 1000L, data, this.configuration.getTelemetryHttpConnector(), this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout()).reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody, (JSONCompareMode)JSONCompareMode.LENIENT)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Map metrics = this.configuration.getTelemetryData().getProduct().getInternals().getMetrics();
        Assertions.assertThat((long)((Metric)metrics.get("unique-task-workers")).getCount()).isEqualTo(0L);
    }

    protected Data adjustData(Data telemetryData, int processCount, int decisionCount, int flowNodeCount, int workerCount) {
        Data result = new Data(telemetryData.getInstallation(), telemetryData.getProduct());
        Product product = result.getProduct();
        product.setVersion("7.14.0");
        result.setProduct(product);
        Internals internals = result.getProduct().getInternals();
        internals.setApplicationServer(new ApplicationServer("WAS 8.5"));
        this.configuration.getTelemetryRegistry().getCommands().clear();
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("IsTelemetryEnabledCmd", new Command(1L));
        internals.setCommands(commands);
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("root-process-instance-start", new Metric((long)processCount));
        metrics.put("executed-decision-instances", new Metric((long)decisionCount));
        metrics.put("activity-instance-start", new Metric((long)flowNodeCount));
        metrics.put("unique-task-workers", new Metric((long)workerCount));
        internals.setMetrics(metrics);
        return result;
    }
}

