/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.batch;

import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.MigrationBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.migration.MigrationPlanExecutionBuilder;

public class MigrationBatchJobHandler
extends AbstractBatchJobHandler<MigrationBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("instance-migration");

    @Override
    public String getType() {
        return "instance-migration";
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    protected MigrationBatchConfigurationJsonConverter getJsonConverterInstance() {
        return MigrationBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    protected MigrationBatchConfiguration createJobConfiguration(MigrationBatchConfiguration configuration, List<String> processIdsForJob) {
        return new MigrationBatchConfiguration(processIdsForJob, configuration.getMigrationPlan(), configuration.isSkipCustomListeners(), configuration.isSkipIoMappings());
    }

    @Override
    protected void postProcessJob(MigrationBatchConfiguration configuration, JobEntity job) {
        if (job.getDeploymentId() == null) {
            CommandContext commandContext = Context.getCommandContext();
            String sourceProcessDefinitionId = configuration.getMigrationPlan().getSourceProcessDefinitionId();
            ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, sourceProcessDefinitionId);
            job.setDeploymentId(processDefinition.getDeploymentId());
        }
    }

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configuration.getConfigurationByteArrayId());
        MigrationBatchConfiguration batchConfiguration = (MigrationBatchConfiguration)this.readConfiguration(configurationEntity.getBytes());
        MigrationPlanExecutionBuilder executionBuilder = commandContext.getProcessEngineConfiguration().getRuntimeService().newMigration(batchConfiguration.getMigrationPlan()).processInstanceIds(batchConfiguration.getIds());
        if (batchConfiguration.isSkipCustomListeners()) {
            executionBuilder.skipCustomListeners();
        }
        if (batchConfiguration.isSkipIoMappings()) {
            executionBuilder.skipIoMappings();
        }
        ((MigrationPlanExecutionBuilderImpl)executionBuilder).execute(false);
        commandContext.getByteArrayManager().delete(configurationEntity);
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }
}

