/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ActivityStatisticsQueryTest
extends PluggableProcessEngineTest {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithoutFailedJobs() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theServiceTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIncidents() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        List incidentStatistics = activityResult.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        List incidentStatistics = activityResult.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithInvalidIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidentsForType("invalid").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        List incidentStatistics = activityResult.getIncidentStatistics();
        Assert.assertTrue((boolean)incidentStatistics.isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIncidentsWithoutFailedJobs() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"callSubProcess", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        List incidentStatistics = activityResult.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void testActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        Assert.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void testActivityStatisticsQueryCount() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        long count = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().count();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void testManyInstancesActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)3L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        Assert.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml"})
    public void testParallelMultiInstanceActivityStatisticsQueryIncludingFailedJobIncidents() {
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("MIExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)3L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        Assert.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml"})
    public void testParallelMultiInstanceActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("MIExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)3L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        Assert.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testSubprocessStatisticsQuery.bpmn20.xml"})
    public void testSubprocessActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
        Assert.assertEquals((Object)"subProcessTask", (Object)result.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityStatisticsQuery.bpmn20.xml", "org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testCallActivityActivityStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
        Assert.assertTrue((boolean)result.getIncidentStatistics().isEmpty());
        ProcessDefinition callSubProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("callExampleSubProcess").singleResult();
        List callSubProcessStatistics = this.managementService.createActivityStatisticsQuery(callSubProcessDefinition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)callSubProcessStatistics.size());
        result = (ActivityStatistics)callSubProcessStatistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
        Assert.assertTrue((boolean)result.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testActivityStatisticsQueryWithIntermediateTimer.bpmn20.xml"})
    public void testActivityStatisticsQueryWithIntermediateTimer() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"theTimer", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        Assert.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testNullProcessDefinitionParameter() {
        try {
            this.managementService.createActivityStatisticsQuery(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml"})
    public void testActivityStatisticsQueryPagination() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ParGatewayExampleProcess").singleResult();
        this.runtimeService.startProcessInstanceById(definition.getId());
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)statistics.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml"})
    public void testParallelGatewayActivityStatisticsQuery() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ParGatewayExampleProcess").singleResult();
        this.runtimeService.startProcessInstanceById(definition.getId());
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        for (ActivityStatistics result : statistics) {
            Assert.assertEquals((long)1L, (long)result.getInstances());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testNonInterruptingBoundaryEventStatisticsQuery.bpmn20.xml"})
    @Test
    public void testNonInterruptingBoundaryEventActivityStatisticsQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job boundaryJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(boundaryJob.getId());
        List activityStatistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).list();
        Assert.assertEquals((long)2L, (long)activityStatistics.size());
        ActivityStatistics userTaskStatistics = this.getStatistics(activityStatistics, "task");
        Assert.assertNotNull((Object)userTaskStatistics);
        Assert.assertEquals((Object)"task", (Object)userTaskStatistics.getId());
        Assert.assertEquals((long)1L, (long)userTaskStatistics.getInstances());
        ActivityStatistics afterBoundaryStatistics = this.getStatistics(activityStatistics, "afterBoundaryTask");
        Assert.assertNotNull((Object)afterBoundaryStatistics);
        Assert.assertEquals((Object)"afterBoundaryTask", (Object)afterBoundaryStatistics.getId());
        Assert.assertEquals((long)1L, (long)afterBoundaryStatistics.getInstances());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testAsyncInterruptingEventSubProcessStatisticsQuery.bpmn20.xml"})
    @Test
    public void testAsyncInterruptingEventSubProcessActivityStatisticsQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("Message");
        ActivityStatistics activityStatistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)activityStatistics);
        Assert.assertEquals((Object)"eventSubprocess", (Object)activityStatistics.getId());
        Assert.assertEquals((long)1L, (long)activityStatistics.getInstances());
    }

    protected ActivityStatistics getStatistics(List<ActivityStatistics> activityStatistics, String activityId) {
        for (ActivityStatistics statistics : activityStatistics) {
            if (!activityId.equals(statistics.getId())) continue;
            return statistics;
        }
        return null;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByIncidentsWithFailedTimerStartEvent() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"theStart", (Object)result.getId());
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByIncidentTypeWithFailedTimerStartEvent() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByFailedJobsWithFailedTimerStartEvent() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByFailedJobsAndIncidentsWithFailedTimerStartEvent() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Ignore(value="CAM-126")
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml"})
    public void testActivityStatisticsQueryWithNoInstances() {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").singleResult();
        List statistics = this.managementService.createActivityStatisticsQuery(definition.getId()).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics result = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"theTask", (Object)result.getId());
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
    }
}

