/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyRepositoryServiceTest {
    protected static final String TENANT_TWO = "tenant2";
    protected static final String TENANT_ONE = "tenant1";
    protected static final BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess().startEvent().done();
    protected static final String CMMN = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected ProcessEngineConfiguration processEngineConfiguration;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void deploymentWithoutTenantId() {
        this.createDeploymentBuilder().deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
        Assertions.assertThat((String)deployment.getTenantId()).isNull();
    }

    @Test
    public void deploymentWithTenantId() {
        this.createDeploymentBuilder().tenantId(TENANT_ONE).deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
        Assertions.assertThat((String)deployment.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void processDefinitionVersionWithTenantId() {
        this.createDeploymentBuilder().tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().tenantId(TENANT_TWO).deploy();
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByTenantId().asc()).orderByProcessDefinitionVersion().asc()).list();
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(3);
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(0)).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(1)).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(2)).getVersion()).isEqualTo(1);
    }

    @Test
    public void deploymentWithDuplicateFilteringForSameTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(1L);
    }

    @Test
    public void deploymentWithDuplicateFilteringForDifferentTenants() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_TWO).deploy();
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(2L);
    }

    @Test
    public void deploymentWithDuplicateFilteringIgnoreDeploymentForNoTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(2L);
    }

    @Test
    public void deploymentWithDuplicateFilteringIgnoreDeploymentForTenant() {
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").tenantId(TENANT_ONE).deploy();
        this.createDeploymentBuilder().enableDuplicateFiltering(false).name("twice").deploy();
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(2L);
    }

    @Test
    public void getPreviousProcessDefinitionWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_TWO, emptyProcess);
        this.testRule.deployForTenant(TENANT_TWO, emptyProcess);
        List latestProcessDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        ProcessDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((ProcessDefinitionEntity)latestProcessDefinitions.get(0));
        ProcessDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((ProcessDefinitionEntity)latestProcessDefinitions.get(1));
        Assertions.assertThat((int)previousDefinitionTenantOne.getVersion()).isEqualTo(2);
        Assertions.assertThat((String)previousDefinitionTenantOne.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((int)previousDefinitionTenantTwo.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)previousDefinitionTenantTwo.getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void getPreviousCaseDefinitionWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        List latestCaseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        CaseDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((CaseDefinitionEntity)latestCaseDefinitions.get(0));
        CaseDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((CaseDefinitionEntity)latestCaseDefinitions.get(1));
        Assertions.assertThat((int)previousDefinitionTenantOne.getVersion()).isEqualTo(2);
        Assertions.assertThat((String)previousDefinitionTenantOne.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((int)previousDefinitionTenantTwo.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)previousDefinitionTenantTwo.getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void getPreviousDecisionDefinitionWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        List latestDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().latestVersion().orderByTenantId().asc()).list();
        DecisionDefinitionEntity previousDefinitionTenantOne = this.getPreviousDefinition((DecisionDefinitionEntity)latestDefinitions.get(0));
        DecisionDefinitionEntity previousDefinitionTenantTwo = this.getPreviousDefinition((DecisionDefinitionEntity)latestDefinitions.get(1));
        Assertions.assertThat((int)previousDefinitionTenantOne.getVersion()).isEqualTo(2);
        Assertions.assertThat((String)previousDefinitionTenantOne.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((int)previousDefinitionTenantTwo.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)previousDefinitionTenantTwo.getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    protected <T extends ResourceDefinitionEntity> T getPreviousDefinition(final T definitionEntity) {
        return (T)((ResourceDefinitionEntity)((ProcessEngineConfigurationImpl)this.processEngineConfiguration).getCommandExecutorTxRequired().execute(new Command<T>(){

            public T execute(CommandContext commandContext) {
                return definitionEntity.getPreviousDefinition();
            }
        }));
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", emptyProcess);
    }

    @After
    public void tearDown() throws Exception {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

