/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyActivityCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final BpmnModelInstance ONE_TASK_PROCESS = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected String processInstanceId;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, ONE_TASK_PROCESS);
        this.processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
    }

    @Test
    public void getActivityInstanceWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertNotNull((Object)this.engineRule.getRuntimeService().getActivityInstance(this.processInstanceId));
    }

    @Test
    public void getActivityInstanceWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().getActivityInstance(this.processInstanceId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void getActivityInstanceWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertNotNull((Object)this.engineRule.getRuntimeService().getActivityInstance(this.processInstanceId));
    }

    @Test
    public void getActivityIdsWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((long)1L, (long)this.engineRule.getRuntimeService().getActiveActivityIds(this.processInstanceId).size());
    }

    @Test
    public void getActivityIdsWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().getActiveActivityIds(this.processInstanceId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void getActivityIdsWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((long)1L, (long)this.engineRule.getRuntimeService().getActiveActivityIds(this.processInstanceId).size());
    }
}

