/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.Set;
import junit.framework.TestCase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.python.google.common.collect.Sets;

public class UpdateProcessInstancesSuspendStateTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchSuspensionById() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).suspend();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchActivatationById() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).suspend();
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).activate();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        TestCase.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        TestCase.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchSuspensionByIdArray() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspend();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchActivatationByIdArray() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).suspend();
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId())).activate();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        TestCase.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        TestCase.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchSuspensionByProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().active()).suspend();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testBatchActivatationByProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().active()).suspend();
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().suspended()).activate();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        TestCase.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        TestCase.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="activity")
    public void testBatchSuspensionByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).suspend();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertTrue((boolean)p2c.isSuspended());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="activity")
    public void testBatchActivatationByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).suspend();
        this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds((Set)Sets.newHashSet((Object[])new String[]{processInstance1.getId(), processInstance2.getId()}))).activate();
        ProcessInstance p1c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        TestCase.assertFalse((boolean)p1c.isSuspended());
        ProcessInstance p2c = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        TestCase.assertFalse((boolean)p2c.isSuspended());
    }

    @Test
    public void testEmptyProcessInstanceListSuspend() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[0]).suspend()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("No process instance ids given");
    }

    @Test
    public void testEmptyProcessInstanceListActivateUpdateProcessInstancesSuspendStateAsyncTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(new String[0]).activate()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("No process instance ids given");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testNullProcessInstanceListActivate() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId(), null)).activate()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot be null");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testNullProcessInstanceListSuspend() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Arrays.asList(processInstance1.getId(), processInstance2.getId(), null)).suspend()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot be null");
    }
}

