/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.cmmn10;

import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.CmmnTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class Cmmn10CompatibilityTest
extends CmmnTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRequiredRule.cmmn"})
    @Test
    public void testRequiredRule() {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("required", (Object)true));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertTrue((boolean)taskExecution.isRequired());
        try {
            this.caseService.completeCaseExecution(caseInstance.getId());
            Assert.fail((String)"completing the containing stage should not be allowed");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testManualActivationRule.cmmn"})
    @Test
    public void testManualActivationRule() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("manual", (Object)false));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertTrue((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testManualActivationRuleWithoutCondition.cmmn"})
    @Test
    public void testManualActivationRuleWithoutCondition() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("manual", (Object)false));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertTrue((boolean)taskExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRepetitionRule.cmmn"})
    @Test
    public void testRepetitionRule() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("repetition", (Object)true));
        String secondHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId();
        this.complete(secondHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRepetitionRuleWithoutEntryCriteria.cmmn"})
    @Test
    public void testRepetitionRuleWithoutEntryCriteria() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("repetition", (Object)true));
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testRepetitionRuleCustomStandardEvent.cmmn"})
    @Test
    public void testRepetitionRuleWithoutEntryCriteriaAndCustomStandardEvent() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("repetition", (Object)true));
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.enabled().count());
        Assert.assertEquals((long)1L, (long)query.disabled().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testPlanItemEntryCriterion.cmmn"})
    @Test
    public void testPlanItemEntryCriterion() {
        this.createCaseInstanceByKey("case");
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask);
        Assert.assertTrue((boolean)this.queryCaseExecutionByActivityId("PI_HumanTask_2").isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testPlanItemExitCriterion.cmmn"})
    @Test
    public void testPlanItemExitCriterion() {
        this.createCaseInstanceByKey("case");
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask);
        Assert.assertNull((Object)this.queryCaseExecutionByActivityId("PI_HumanTask_2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testCasePlanModelExitCriterion.cmmn"})
    @Test
    public void testCasePlanModelExitCriterion() {
        String caseInstanceId = this.createCaseInstanceByKey("case").getId();
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask);
        Assert.assertTrue((boolean)this.queryCaseExecutionById(caseInstanceId).isTerminated());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testSentryIfPartCondition.cmmn"})
    @Test
    public void testSentryIfPartCondition() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("value", (Object)99));
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        String humanTask2 = this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId();
        Assert.assertTrue((boolean)this.queryCaseExecutionById(humanTask2).isAvailable());
        this.caseService.withCaseExecution(humanTask1).setVariable("value", (Object)999).manualStart();
        Assert.assertTrue((boolean)this.queryCaseExecutionById(humanTask2).isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/cmm10/Cmmn10CompatibilityTest.testDescription.cmmn"})
    @Test
    public void testDescription() {
        this.createCaseInstanceByKey("case");
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"This is a description!", (Object)task.getDescription());
    }
}

