/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricCaseInstanceQuery;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.cmmn.CmmnTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricCaseInstanceTest
extends CmmnTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    @Test
    public void testCaseInstanceProperties() {
        CaseInstance caseInstance = this.createCaseInstance();
        HistoricCaseInstance historicInstance = this.queryHistoricCaseInstance(caseInstance.getId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)historicInstance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)historicInstance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)historicInstance.getCaseDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageWithManualActivationCase.cmmn"})
    @Test
    public void testCaseInstanceStates() {
        String caseInstanceId = this.createCaseInstance().getId();
        HistoricCaseInstance historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Assert.assertTrue((boolean)historicCaseInstance.isActive());
        this.assertCount(1L, this.historicQuery().active());
        this.assertCount(1L, this.historicQuery().notClosed());
        String stageExecutionId = this.queryCaseExecutionByActivityId("PI_Stage_1").getId();
        this.manualStart(stageExecutionId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Assert.assertTrue((boolean)historicCaseInstance.isCompleted());
        this.assertCount(1L, this.historicQuery().completed());
        this.assertCount(1L, this.historicQuery().notClosed());
        this.reactivate(caseInstanceId);
        this.terminate(caseInstanceId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Assert.assertTrue((boolean)historicCaseInstance.isTerminated());
        this.assertCount(1L, this.historicQuery().terminated());
        this.assertCount(1L, this.historicQuery().notClosed());
        this.reactivate(caseInstanceId);
        this.suspend(caseInstanceId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Assert.assertTrue((boolean)((HistoricCaseInstanceEntity)historicCaseInstance).isSuspended());
        this.assertCount(1L, this.historicQuery().notClosed());
        this.close(caseInstanceId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Assert.assertTrue((boolean)historicCaseInstance.isClosed());
        this.assertCount(1L, this.historicQuery().closed());
        this.assertCount(0L, this.historicQuery().notClosed());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageWithManualActivationCase.cmmn"})
    @Test
    public void testHistoricCaseInstanceDates() {
        long duration = 259200000L;
        Date created = ClockUtil.getCurrentTime();
        Date closed = new Date(created.getTime() + duration);
        ClockUtil.setCurrentTime((Date)created);
        String caseInstanceId = this.createCaseInstance().getId();
        this.terminate(caseInstanceId);
        ClockUtil.setCurrentTime((Date)closed);
        this.close(caseInstanceId);
        HistoricCaseInstance historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Date createTime = historicCaseInstance.getCreateTime();
        Date closeTime = historicCaseInstance.getCloseTime();
        Long durationInMillis = historicCaseInstance.getDurationInMillis();
        this.assertDateSimilar(created, createTime);
        this.assertDateSimilar(closed, closeTime);
        Assert.assertTrue((durationInMillis >= duration ? 1 : 0) != 0);
        Assert.assertTrue((durationInMillis < duration + 1000L ? 1 : 0) != 0);
        Date beforeCreate = new Date(created.getTime() - 3600000L);
        Date afterClose = new Date(closed.getTime() + 3600000L);
        this.assertCount(1L, this.historicQuery().createdAfter(beforeCreate));
        this.assertCount(0L, this.historicQuery().createdAfter(closed));
        this.assertCount(0L, this.historicQuery().createdBefore(beforeCreate));
        this.assertCount(1L, this.historicQuery().createdBefore(closed));
        this.assertCount(0L, this.historicQuery().createdBefore(beforeCreate).createdAfter(closed));
        this.assertCount(1L, this.historicQuery().closedAfter(created));
        this.assertCount(0L, this.historicQuery().closedAfter(afterClose));
        this.assertCount(0L, this.historicQuery().closedBefore(created));
        this.assertCount(1L, this.historicQuery().closedBefore(afterClose));
        this.assertCount(0L, this.historicQuery().closedBefore(created).closedAfter(afterClose));
        this.assertCount(1L, this.historicQuery().closedBefore(afterClose).closedAfter(created));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    @Test
    public void testCreateUser() {
        String userId = "test";
        this.identityService.setAuthenticatedUserId(userId);
        String caseInstanceId = this.createCaseInstance().getId();
        HistoricCaseInstance historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Assert.assertEquals((Object)userId, (Object)historicCaseInstance.getCreateUserId());
        this.assertCount(1L, this.historicQuery().createdBy(userId));
        this.identityService.setAuthenticatedUserId(null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testSuperCaseInstance() {
        String caseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        HistoricCaseInstance historicCaseInstance = (HistoricCaseInstance)this.historicQuery().superCaseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)historicCaseInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)historicCaseInstance.getSuperCaseInstanceId());
        String superCaseInstanceId = ((HistoricCaseInstance)this.historicQuery().subCaseInstanceId(historicCaseInstance.getId()).singleResult()).getId();
        Assert.assertEquals((Object)caseInstanceId, (Object)superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn", "org/camunda/bpm/engine/test/api/repository/three_.cmmn"})
    @Test
    public void testHistoricCaseInstanceQuery() {
        CaseInstance oneTaskCase = this.createCaseInstanceByKey("oneTaskCase", "oneBusiness");
        CaseInstance twoTaskCase = this.createCaseInstanceByKey("twoTaskCase", "twoBusiness");
        this.createCaseInstanceByKey("xyz_", "xyz_");
        this.assertCount(1L, this.historicQuery().caseInstanceId(oneTaskCase.getId()));
        this.assertCount(1L, this.historicQuery().caseInstanceId(twoTaskCase.getId()));
        HashSet<String> caseInstanceIds = new HashSet<String>();
        caseInstanceIds.add(oneTaskCase.getId());
        caseInstanceIds.add("unknown1");
        caseInstanceIds.add(twoTaskCase.getId());
        caseInstanceIds.add("unknown2");
        this.assertCount(2L, this.historicQuery().caseInstanceIds(caseInstanceIds));
        this.assertCount(0L, this.historicQuery().caseInstanceIds(caseInstanceIds).caseInstanceId("someOtherId"));
        this.assertCount(1L, this.historicQuery().caseDefinitionId(oneTaskCase.getCaseDefinitionId()));
        this.assertCount(1L, this.historicQuery().caseDefinitionKey("oneTaskCase"));
        this.assertCount(3L, this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList("unknown")));
        this.assertCount(2L, this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList("oneTaskCase")));
        this.assertCount(1L, this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList("oneTaskCase", "twoTaskCase")));
        this.assertCount(0L, this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList("oneTaskCase")).caseDefinitionKey("oneTaskCase"));
        try {
            this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList(""));
            Assert.fail((String)"Exception expected");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        this.assertCount(1L, this.historicQuery().caseDefinitionName("One Task Case"));
        this.assertCount(2L, this.historicQuery().caseDefinitionNameLike("%T%"));
        this.assertCount(1L, this.historicQuery().caseDefinitionNameLike("One%"));
        this.assertCount(0L, this.historicQuery().caseDefinitionNameLike("%Process%"));
        this.assertCount(1L, this.historicQuery().caseDefinitionNameLike("%z\\_"));
        this.assertCount(1L, this.historicQuery().caseInstanceBusinessKey("oneBusiness"));
        this.assertCount(2L, this.historicQuery().caseInstanceBusinessKeyLike("%Business"));
        this.assertCount(1L, this.historicQuery().caseInstanceBusinessKeyLike("one%"));
        this.assertCount(0L, this.historicQuery().caseInstanceBusinessKeyLike("%unknown%"));
        this.assertCount(1L, this.historicQuery().caseInstanceBusinessKeyLike("%z\\_"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByVariable() {
        String caseInstanceId = this.createCaseInstance().getId();
        this.caseService.setVariable(caseInstanceId, "foo", (Object)"bar");
        this.caseService.setVariable(caseInstanceId, "number", (Object)10);
        this.assertCount(1L, this.historicQuery().variableValueEquals("foo", (Object)"bar"));
        this.assertCount(0L, this.historicQuery().variableValueNotEquals("foo", (Object)"bar"));
        this.assertCount(1L, this.historicQuery().variableValueNotEquals("foo", (Object)"lol"));
        this.assertCount(0L, this.historicQuery().variableValueEquals("foo", (Object)"lol"));
        this.assertCount(1L, this.historicQuery().variableValueLike("foo", "%a%"));
        this.assertCount(0L, this.historicQuery().variableValueLike("foo", "%lol%"));
        this.assertCount(1L, this.historicQuery().variableValueEquals("number", (Object)10));
        this.assertCount(0L, this.historicQuery().variableValueNotEquals("number", (Object)10));
        this.assertCount(1L, this.historicQuery().variableValueNotEquals("number", (Object)1));
        this.assertCount(1L, this.historicQuery().variableValueGreaterThan("number", (Object)1));
        this.assertCount(0L, this.historicQuery().variableValueLessThan("number", (Object)1));
        this.assertCount(1L, this.historicQuery().variableValueGreaterThanOrEqual("number", (Object)10));
        this.assertCount(0L, this.historicQuery().variableValueLessThan("number", (Object)10));
        this.assertCount(1L, this.historicQuery().variableValueLessThan("number", (Object)20));
        this.assertCount(0L, this.historicQuery().variableValueGreaterThan("number", (Object)20));
        this.assertCount(1L, this.historicQuery().variableValueLessThanOrEqual("number", (Object)10));
        this.assertCount(0L, this.historicQuery().variableValueGreaterThan("number", (Object)10));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCaseVariableValueEqualsNumber() throws Exception {
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123L).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)12345L).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123.0).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", null).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)Variables.longValue(null)).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)"123").create();
        Assert.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        Assert.assertEquals((long)3L, (long)this.historicQuery().listPage(0, 3).size());
        Assert.assertEquals((long)2L, (long)this.historicQuery().listPage(2, 2).size());
        Assert.assertEquals((long)1L, (long)this.historicQuery().listPage(3, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    @Test
    public void testQuerySorting() {
        String oneCaseInstanceId = this.createCaseInstanceByKey("oneTaskCase", "oneBusinessKey").getId();
        String twoCaseInstanceId = this.createCaseInstanceByKey("twoTaskCase", "twoBusinessKey").getId();
        this.terminate(oneCaseInstanceId);
        this.close(oneCaseInstanceId);
        ClockUtil.setCurrentTime((Date)DateTimeUtil.now().plusHours(1).toDate());
        this.terminate(twoCaseInstanceId);
        this.close(twoCaseInstanceId);
        HistoricCaseInstance oneCaseInstance = this.queryHistoricCaseInstance(oneCaseInstanceId);
        HistoricCaseInstance twoCaseInstance = this.queryHistoricCaseInstance(twoCaseInstanceId);
        List<Object> sortedList = Arrays.asList(oneCaseInstance.getId(), twoCaseInstance.getId());
        Collections.sort(sortedList);
        List instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceId().asc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("id").containsExactly(new Object[]{sortedList.get(0), sortedList.get(1)});
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceId().desc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("id").containsExactly(new Object[]{sortedList.get(1), sortedList.get(0)});
        sortedList = Arrays.asList(oneCaseInstance.getCaseDefinitionId(), twoCaseInstance.getCaseDefinitionId());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseDefinitionId().asc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("caseDefinitionId").containsExactly(new Object[]{sortedList.get(0), sortedList.get(1)});
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseDefinitionId().desc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("caseDefinitionId").containsExactly(new Object[]{sortedList.get(1), sortedList.get(0)});
        sortedList = Arrays.asList(oneCaseInstance.getBusinessKey(), twoCaseInstance.getBusinessKey());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceBusinessKey().asc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("businessKey").containsExactly(new Object[]{sortedList.get(0), sortedList.get(1)});
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceBusinessKey().desc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("businessKey").containsExactly(new Object[]{sortedList.get(1), sortedList.get(0)});
        sortedList = Arrays.asList(oneCaseInstance.getCreateTime(), twoCaseInstance.getCreateTime());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCreateTime().asc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("createTime").containsExactly(new Object[]{sortedList.get(0), sortedList.get(1)});
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCreateTime().desc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("createTime").containsExactly(new Object[]{sortedList.get(1), sortedList.get(0)});
        sortedList = Arrays.asList(oneCaseInstance.getCloseTime(), twoCaseInstance.getCloseTime());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCloseTime().asc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("closeTime").containsExactly(new Object[]{sortedList.get(0), sortedList.get(1)});
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCloseTime().desc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("closeTime").containsExactly(new Object[]{sortedList.get(1), sortedList.get(0)});
        sortedList = Arrays.asList(oneCaseInstance.getDurationInMillis(), twoCaseInstance.getDurationInMillis());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceDuration().asc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("durationInMillis").containsExactly(new Object[]{sortedList.get(0), sortedList.get(1)});
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceDuration().desc()).list();
        Assert.assertEquals((long)2L, (long)instances.size());
        Assertions.assertThat((List)instances).extracting("durationInMillis").containsExactly(new Object[]{sortedList.get(1), sortedList.get(0)});
    }

    @Test
    public void testInvalidSorting() {
        try {
            this.historicQuery().asc();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historicQuery().desc();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historicQuery().orderByCaseInstanceId().count();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testNativeQuery() {
        String id = this.createCaseInstance().getId();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        String tableName = this.managementService.getTableName(HistoricCaseInstance.class);
        Assert.assertEquals((Object)(tablePrefix + "ACT_HI_CASEINST"), (Object)tableName);
        Assert.assertEquals((Object)tableName, (Object)this.managementService.getTableName(HistoricCaseInstanceEntity.class));
        Assert.assertEquals((long)4L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName)).list().size());
        Assert.assertEquals((long)4L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName)).count());
        Assert.assertEquals((long)16L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H1, " + tableName + " H2")).count());
        Assert.assertEquals((long)4L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT DISTINCT * FROM " + tableName)).list().size());
        Assert.assertEquals((long)1L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = '" + id + "'")).count());
        Assert.assertEquals((long)1L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName + " H WHERE H.ID_ = '" + id + "'")).list().size());
        Assert.assertEquals((long)1L, (long)((NativeHistoricCaseInstanceQuery)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = #{caseInstanceId}")).parameter("caseInstanceId", (Object)id)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testNativeQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String tableName = this.managementService.getTableName(HistoricCaseInstance.class);
        Assert.assertEquals((long)3L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(0, 3).size());
        Assert.assertEquals((long)2L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(2, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageWithManualActivationCase.cmmn"})
    @Test
    public void testDeleteHistoricCaseInstance() {
        CaseInstance caseInstance = this.createCaseInstance();
        String caseInstanceId = caseInstance.getId();
        HistoricCaseInstance historicInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Assert.assertNotNull((Object)historicInstance);
        try {
            this.historyService.deleteHistoricCaseInstance(historicInstance.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        this.terminate(caseInstanceId);
        this.close(caseInstanceId);
        this.identityService.setAuthenticatedUserId("testUser");
        this.historyService.deleteHistoricCaseInstance(historicInstance.getId());
        this.identityService.clearAuthentication();
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            Assert.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().count());
            UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
            Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
            Assert.assertEquals((Object)"CaseInstance", (Object)entry.getEntityType());
            Assert.assertEquals((Object)"DeleteHistory", (Object)entry.getOperationType());
            Assert.assertEquals((Object)caseInstanceId, (Object)entry.getCaseInstanceId());
            Assert.assertNull((Object)entry.getProperty());
            Assert.assertNull((Object)entry.getOrgValue());
            Assert.assertNull((Object)entry.getNewValue());
        }
        this.assertCount(0L, this.historicQuery());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySuperProcessInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance subCaseInstance = (HistoricCaseInstance)query.singleResult();
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertEquals((Object)superProcessInstanceId, (Object)subCaseInstance.getSuperProcessInstanceId());
        Assert.assertNull((Object)subCaseInstance.getSuperCaseInstanceId());
    }

    @Test
    public void testQueryByInvalidSuperProcessInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.superProcessInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryBySubProcessInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String subProcessInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId).singleResult()).getId();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().subProcessInstanceId(subProcessInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)query.singleResult();
        Assert.assertEquals((Object)superCaseInstanceId, (Object)caseInstance.getId());
        Assert.assertNull((Object)caseInstance.getSuperCaseInstanceId());
        Assert.assertNull((Object)caseInstance.getSuperProcessInstanceId());
    }

    @Test
    public void testQueryByInvalidSubProcessInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.subProcessInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneCaseTaskCase").getId();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)query.singleResult();
        Assert.assertEquals((Object)superCaseInstanceId, (Object)caseInstance.getSuperCaseInstanceId());
        Assert.assertNull((Object)caseInstance.getSuperProcessInstanceId());
    }

    @Test
    public void testQueryByInvalidSuperCaseInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.superCaseInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySubCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superCaseInstanceId(superCaseInstanceId).singleResult()).getId();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)query.singleResult();
        Assert.assertEquals((Object)superCaseInstanceId, (Object)caseInstance.getId());
        Assert.assertNull((Object)caseInstance.getSuperProcessInstanceId());
        Assert.assertNull((Object)caseInstance.getSuperCaseInstanceId());
    }

    @Test
    public void testQueryByInvalidSubCaseInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.subCaseInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseActivityId() {
        this.createCaseInstanceByKey("oneTaskCase");
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseActivityIds() {
        this.createCaseInstanceByKey("oneCaseTaskCase");
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1", "PI_CaseTask_1"});
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    @Test
    public void testDistinctQueryByCaseActivityIds() {
        this.createCaseInstanceByKey("twoTaskCase");
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1", "PI_HumanTask_2"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByNonExistingCaseActivityId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().caseActivityIdIn(new String[]{"nonExisting"});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    public void testFailQueryByCaseActivityIdNull() {
        try {
            this.historyService.createHistoricCaseInstanceQuery().caseActivityIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testRetrieveCaseDefinitionKey() {
        String id = this.createCaseInstance("oneTaskCase").getId();
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.historyService.createHistoricCaseInstanceQuery().caseInstanceId(id).singleResult();
        Assert.assertEquals((Object)"oneTaskCase", (Object)caseInstance.getCaseDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testRetrieveCaseDefinitionName() {
        String id = this.createCaseInstance("oneTaskCase").getId();
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.historyService.createHistoricCaseInstanceQuery().caseInstanceId(id).singleResult();
        Assert.assertEquals((Object)"One Task Case", (Object)caseInstance.getCaseDefinitionName());
    }

    protected HistoricCaseInstance queryHistoricCaseInstance(String caseInstanceId) {
        HistoricCaseInstance historicCaseInstance = (HistoricCaseInstance)this.historicQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertNotNull((Object)historicCaseInstance);
        return historicCaseInstance;
    }

    protected HistoricCaseInstanceQuery historicQuery() {
        return this.historyService.createHistoricCaseInstanceQuery();
    }

    protected void assertCount(long count, HistoricCaseInstanceQuery historicQuery) {
        Assert.assertEquals((long)count, (long)historicQuery.count());
    }

    protected void assertDateSimilar(Date date1, Date date2) {
        long difference = Math.abs(date1.getTime() - date2.getTime());
        Assert.assertTrue((difference < 1000L ? 1 : 0) != 0);
    }
}

