/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.HistoricTaskPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.UserOperationLogCategoryPermissions;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class UserOperationLogAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String ONE_TASK_CASE_KEY = "oneTaskCase";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected String deploymentId;
    protected String taskId;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
        if (this.taskId != null) {
            this.deleteTask(this.taskId, true);
            this.taskId = null;
        }
    }

    @Test
    public void testQueryCreateStandaloneTaskUserOperationLogWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryCreateStandaloneTaskUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    public void failing_testQueryCreateStandaloneTaskUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryCreateStandaloneTaskUserOperationLogWithReadPermissionOnCategory() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryCreateStandaloneTaskUserOperationLogWithReadPermissionOnAnyCategory() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryCreateStandaloneTaskUserOperationLogWithReadPermissionOnAnyCategoryAndRevokeReadHistoryOnProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        this.createRevokeAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void failing_testQueryCreateStandaloneTaskUserOperationLogWithReadPermissionOnAnyCategoryAndRevokeReadHistoryOnAnyProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        this.createRevokeAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQuerySetAssigneeStandaloneTaskUserOperationLogWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQuerySetAssigneeStandaloneTaskUserOperationLogWithReadPermissionOnProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    public void failing_testQuerySetAssigneeStandaloneTaskUserOperationLogWithReadPermissionOnAnyProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQuerySetAssigneeStandaloneTaskUserOperationLogWithReadPermissionOnCategory() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQuerySetAssigneeStandaloneTaskUserOperationLogWithReadPermissionOnAnyCategory() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithMultiple() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getProcessInstanceId();
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getProcessInstanceId();
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getProcessInstanceId();
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getProcessInstanceId();
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndTaskWorkerCategory() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getProcessInstanceId();
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndAdminCategory() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getProcessInstanceId();
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId});
    }

    @Test
    public void testHistoricProcessInstancePermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getProcessInstanceId();
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().processInstanceId(processInstanceId);
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId});
    }

    @Test
    public void testCheckNonePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactly(new Object[]{taskId});
    }

    @Test
    public void testCheckReadPermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.taskId = "aTaskId";
        this.createTask(this.taskId);
        this.disableAuthorization();
        this.taskService.setAssignee(this.taskId, this.userId);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, this.taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactly(new Object[]{this.taskId, this.taskId});
    }

    @Test
    public void testCheckNonePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.taskId = "aTaskId";
        this.createTask(this.taskId);
        this.disableAuthorization();
        this.taskService.setAssignee(this.taskId, this.userId);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, this.taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setAssignee(taskId, this.userId);
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactly(new Object[]{taskId, taskId});
    }

    @Test
    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactlyInAnyOrder(new Object[]{taskId, null});
    }

    @Test
    public void testCheckReadPermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactly(new Object[]{taskId});
    }

    @Test
    public void testCheckNoneOnHistoricTaskAndTaskWorkerCategory() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactly(new Object[]{taskId});
    }

    @Test
    public void testCheckReadOnHistoricTaskAndAdminCategory() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactly(new Object[]{taskId});
    }

    @Test
    public void testHistoricTaskPermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assertions.assertThat((List)query.list()).extracting("taskId").containsExactlyInAnyOrder(new Object[]{taskId, null});
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithReadPermissionOnCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithReadPermissionOnAnyCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithReadPermissionOnAnyCategoryAndRevokeOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        this.createRevokeAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithReadPermissionOnAnyCategoryAndRevokeOnUnrelatedProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        this.createRevokeAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_CASE_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySetAssigneeTaskUserOperationLogWithReadPermissionOnAnyCategoryAndRevokeOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        this.createRevokeAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySetAssigneeHumanTaskUserOperationLogWithoutAuthorization() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySetAssigneeHumanTaskUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_CASE_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    public void failing_testQuerySetAssigneeHumanTaskUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySetAssigneeHumanTaskUserOperationLogWithReadPermissionOnCategory() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQuerySetAssigneeHumanTaskUserOperationLogWithReadPermissionOnAnyCategory() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQuerySetStandaloneJobRetriesUserOperationLogWithoutAuthorization() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testQuerySetStandaloneJobRetriesUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        Assert.assertEquals((Object)ONE_TASK_PROCESS_KEY, (Object)((UserOperationLogEntry)query.list().get(0)).getProcessDefinitionKey());
        Assert.assertEquals((Object)ONE_TASK_PROCESS_KEY, (Object)((UserOperationLogEntry)query.list().get(1)).getProcessDefinitionKey());
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Ignore(value="CAM-9888")
    @Test
    public void testQuerySetStandaloneJobRetriesUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        this.identityService.clearAuthentication();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        this.disableAuthorization();
        this.identityService.setAuthentication(this.userId, null);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testQuerySetStandaloneJobRetriesUserOperationLogWithReadPermissionOnCategory() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Operator", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testQuerySetStandaloneJobRetriesUserOperationLogWithReadPermissionOnAnyCategory() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testQuerySetStandaloneJobRetriesUserOperationLogWithReadPermissionOnWrongCategory() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testQuerySetJobRetriesUserOperationLogWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySetJobRetriesUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySetJobRetriesUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySetJobRetriesUserOperationLogWithReadPermissionOnCategory() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Operator", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySetJobRetriesUserOperationLogWithReadPermissionOnAnyCategory() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQuerySuspendProcessDefinitionUserOperationLogWithoutAuthorization() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessDefinitionUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessDefinitionUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessDefinitionUserOperationLogWithReadHPermissionOnCategory() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Operator", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessDefinitionUserOperationLogWithReadHPermissionOnAnyCategory() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessInstanceUserOperationLogWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessInstanceUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessInstanceUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessInstanceUserOperationLogWithReadPermissionOnCategory() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Operator", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQuerySuspendProcessInstanceUserOperationLogWithReadPermissionOnAnyCategory() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.clearDatabase();
    }

    @Test
    public void testQueryAfterDeletingDeploymentWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.deleteDeployment(this.deploymentId, false);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testQueryAfterDeletingDeploymentWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.deleteDeployment(this.deploymentId, false);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testQueryAfterDeletingDeploymentWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.deleteDeployment(this.deploymentId, false);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testQueryAfterDeletingDeploymentWithReadPermissionOnCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.deleteDeployment(this.deploymentId, false);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Operator", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testQueryAfterDeletingDeploymentWithReadPermissionOnAnyCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.deleteDeployment(this.deploymentId, false);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testDeleteStandaloneEntryWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(UserOperationLogCategoryPermissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteStandaloneEntryWithDeleteHistoryPermissionOnProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(UserOperationLogCategoryPermissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteStandaloneEntryWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(UserOperationLogCategoryPermissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteStandaloneEntryWithDeletePermissionOnCategory() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.DELETE});
        this.historyService.deleteUserOperationLogEntry(entryId);
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteStandaloneEntryWithDeletePermissionOnAnyCategory() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.DELETE});
        this.historyService.deleteUserOperationLogEntry(entryId);
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteEntryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getId();
        this.enableAuthorization();
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.testRule.assertTextPresent(UserOperationLogCategoryPermissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
    }

    @Test
    public void testDeleteEntryWithDeleteHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getId();
        this.enableAuthorization();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult());
        this.enableAuthorization();
    }

    @Test
    public void testDeleteEntryWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getId();
        this.enableAuthorization();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult());
        this.enableAuthorization();
    }

    @Test
    public void testDeleteEntryWithDeletePermissionOnCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.DELETE});
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getId();
        this.enableAuthorization();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult());
        this.enableAuthorization();
    }

    @Test
    public void testDeleteEntryWithDeletePermissionOnAnyCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.DELETE});
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getId();
        this.enableAuthorization();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult());
        this.enableAuthorization();
    }

    @Test
    public void testDeleteEntryAfterDeletingDeployment() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY, Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.deleteDeployment(this.deploymentId, false);
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getId();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult());
        this.enableAuthorization();
        this.disableAuthorization();
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.enableAuthorization();
    }

    @Test
    public void testCaseDeleteEntryWithoutAuthorization() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(UserOperationLogCategoryPermissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
    }

    @Test
    public void testCaseDeleteEntryWithDeleteHistoryPermissionOnProcessDefinition() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_CASE_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(UserOperationLogCategoryPermissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
    }

    @Test
    public void testCaseDeleteEntryWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(UserOperationLogCategoryPermissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
    }

    @Test
    public void testCaseDeleteEntryWithDeletePermissionOnCategory() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.DELETE});
        this.historyService.deleteUserOperationLogEntry(entryId);
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
    }

    @Test
    public void testCaseDeleteEntryWithDeletePermissionOnAnyCategory() {
        this.testRule.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.DELETE});
        this.historyService.deleteUserOperationLogEntry(entryId);
        Assert.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
    }

    @Test
    public void testUpdateEntryWithUpdateHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_HISTORY});
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
        this.disableAuthorization();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.enableAuthorization();
        this.testRule.assertTextPresent(userOperationLogEntry.getAnnotation(), "anAnnotation");
    }

    @Test
    public void testUpdateEntryWithUpdateHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_HISTORY});
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
        this.disableAuthorization();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.enableAuthorization();
        this.testRule.assertTextPresent(userOperationLogEntry.getAnnotation(), "anAnnotation");
    }

    @Test
    public void testUpdateEntryWithUpdateHistoryPermissionOnAnyProcessDefinition_Standalone() {
        this.createTask("aTaskId");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_HISTORY});
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        try {
            this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
            Assert.fail((String)"Exception expected: It should not be possible to update the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
        this.deleteTask("aTaskId", true);
    }

    @Test
    public void testUpdateEntryRelatedToProcessDefinitionWithUpdatePermissionOnCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.UPDATE});
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
        this.disableAuthorization();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.enableAuthorization();
        this.testRule.assertTextPresent(userOperationLogEntry.getAnnotation(), "anAnnotation");
    }

    @Test
    public void testUpdateEntryRelatedToProcessDefinitionWithUpdatePermissionOnAnyCategory() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.UPDATE});
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
        this.disableAuthorization();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.enableAuthorization();
        this.testRule.assertTextPresent(userOperationLogEntry.getAnnotation(), "anAnnotation");
    }

    @Test
    public void testUpdateEntryWithoutAuthorization() {
        this.createTask("aTaskId");
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        try {
            this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
            Assert.fail((String)"Exception expected: It should not be possible to update the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.OPERATION_LOG_CATEGORY.resourceName(), message);
            this.testRule.assertTextPresent("TaskWorker", message);
        }
        this.deleteTask("aTaskId", true);
    }

    @Test
    public void testUpdateEntryWithUpdatePermissionOnCategory() {
        this.createTask("aTaskId");
        this.createGrantAuthorization((Resource)Resources.OPERATION_LOG_CATEGORY, "TaskWorker", this.userId, new Permission[]{UserOperationLogCategoryPermissions.UPDATE});
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
        this.disableAuthorization();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.enableAuthorization();
        this.testRule.assertTextPresent(userOperationLogEntry.getAnnotation(), "anAnnotation");
        this.deleteTask("aTaskId", true);
    }

    @Test
    public void testUpdateEntryWithUpdatePermissionOnAnyCategory() {
        this.createTask("aTaskId");
        this.createGrantAuthorization((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.UPDATE});
        this.disableAuthorization();
        String operationId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getOperationId();
        this.enableAuthorization();
        this.historyService.setAnnotationForOperationLogById(operationId, "anAnnotation");
        this.disableAuthorization();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.enableAuthorization();
        this.testRule.assertTextPresent(userOperationLogEntry.getAnnotation(), "anAnnotation");
        this.deleteTask("aTaskId", true);
    }

    protected void verifyQueryResults(UserOperationLogQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected Job selectSingleJob() {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.enableAuthorization();
        return job;
    }

    protected void clearDatabase() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                List incidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident incident : incidents) {
                    commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)incident));
                }
                return null;
            }
        });
    }
}

