/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class JobQueryByPriorityTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testOrderByPriority() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        TestOrderingUtil.verifySortingAndCount(this.managementService.createJobQuery().orderByJobPriority().asc(), 5, TestOrderingUtil.jobByPriority());
        TestOrderingUtil.verifySortingAndCount(this.managementService.createJobQuery().orderByJobPriority().desc(), 5, TestOrderingUtil.inverted(TestOrderingUtil.jobByPriority()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testFilterByJobPriorityLowerThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List jobs = this.managementService.createJobQuery().priorityLowerThanOrEquals(2L).list();
        Assert.assertEquals((long)3L, (long)jobs.size());
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add(((ProcessInstance)instances.get(0)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(1)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(2)).getId());
        for (Job job : jobs) {
            Assert.assertTrue((job.getPriority() <= 2L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)processInstanceIds.contains(job.getProcessInstanceId()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testFilterByJobPriorityLowerThanOrEqualsAndHigherThanOrEqual() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().priorityLowerThanOrEquals(2L).priorityHigherThanOrEquals(3L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testFilterByJobPriorityHigherThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List jobs = this.managementService.createJobQuery().priorityHigherThanOrEquals(2L).list();
        Assert.assertEquals((long)3L, (long)jobs.size());
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add(((ProcessInstance)instances.get(2)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(3)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(4)).getId());
        for (Job job : jobs) {
            Assert.assertTrue((job.getPriority() >= 2L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)processInstanceIds.contains(job.getProcessInstanceId()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testFilterByJobPriorityLowerAndHigher() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        Job job = (Job)this.managementService.createJobQuery().priorityHigherThanOrEquals(2L).priorityLowerThanOrEquals(2L).singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)2L, (long)job.getPriority());
        Assert.assertEquals((Object)((ProcessInstance)instances.get(2)).getId(), (Object)job.getProcessInstanceId());
    }
}

