/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.Map;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.engine.test.bpmn.event.conditional.SetVariableDelegate;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.EventBasedGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.ParallelGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Test;

public class IntermediateConditionalEventTest
extends AbstractConditionalEventTestCase {
    protected static final String EVENT_BASED_GATEWAY_ID = "egw";
    protected static final String PARALLEL_GATEWAY_ID = "parallelGateway";
    protected static final String TASK_BEFORE_SERVICE_TASK_ID = "taskBeforeServiceTask";
    protected static final String TASK_BEFORE_EVENT_BASED_GW_ID = "taskBeforeEGW";

    @Override
    public void checkIfProcessCanBeFinished() {
    }

    @Test
    @Deployment
    public void testFalseCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.processInstanceId(procInst.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNull((Object)execution);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
    }

    @Test
    @Deployment
    public void testVariableValue() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNull((Object)execution);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testParallelVariableValue() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent1").singleResult();
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent2").singleResult();
        Assert.assertEquals((long)2L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution1.getId(), "variable", (Object)1);
        execution1 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent1").singleResult();
        Assert.assertNull((Object)execution1);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution2.getId(), "variable", (Object)2);
        execution2 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent2").singleResult();
        Assert.assertNull((Object)execution2);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testParallelVariableValueEqualConditions() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/IntermediateConditionalEventTest.testParallelVariableValue.bpmn20.xml"})
    public void testParallelVariableSetValueOnParent() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent1").singleResult();
        Assert.assertNull((Object)execution);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)2);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent2").singleResult();
        Assert.assertNull((Object)execution);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment
    public void testSubProcessVariableValue() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.setVariableLocal(execution.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNull((Object)execution);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/IntermediateConditionalEventTest.testSubProcessVariableValue.bpmn20.xml"})
    public void testSubProcessVariableSetValueOnParent() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        procInst = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("conditionalEventProcess").singleResult();
        Assert.assertNull((Object)procInst);
    }

    @Test
    @Deployment
    public void testCleanUpConditionalEventSubscriptions() {
        VariableMap variables = Variables.createVariables();
        variables.put("variable", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(execution.getId(), "variable", (Object)1);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(procInst.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testVariableConditionWithVariableName() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).camundaVariableName("variable")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testVariableConditionWithVariableEvent() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).camundaVariableEvents("update")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        VariableMap variables = Variables.createVariables();
        variables.put("variable1", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testVariableConditionWithVariableNameAndEvent() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).camundaVariableName("variable")).camundaVariableEvents("update")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("conditionalEvent").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testSuspendedProcess() {
        BpmnModelInstance modelInstance = ((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        this.runtimeService.suspendProcessInstanceById(procInst.getId());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        Assert.assertTrue((boolean)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).isSuspended());
        try {
            this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
            Assert.fail((String)"Should fail!");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(procInst.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
    }

    @Test
    public void testEventBasedGateway() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().eventBasedGateway().id(EVENT_BASED_GATEWAY_ID)).intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(EVENT_BASED_GATEWAY_ID).singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testEventBasedGatewayTrueCondition() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((EventBasedGatewayBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).eventBasedGateway().id(EVENT_BASED_GATEWAY_ID)).intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${true}")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(EVENT_BASED_GATEWAY_ID).singleResult();
        Assert.assertNull((Object)execution);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
    }

    @Test
    public void testEventBasedGatewayWith2ConditionsOneIsTrue() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((EventBasedGatewayBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).eventBasedGateway().id(EVENT_BASED_GATEWAY_ID)).intermediateCatchEvent().conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name("After Condition1")).endEvent().moveToLastGateway().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${true}")).conditionalEventDefinitionDone().userTask().name("After Condition2")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(EVENT_BASED_GATEWAY_ID).singleResult();
        Assert.assertNull((Object)execution);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"After Condition2", (Object)task.getName());
    }

    @Test
    public void testEventBasedGatewayWith2VarConditions() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().eventBasedGateway().id(EVENT_BASED_GATEWAY_ID)).intermediateCatchEvent().conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name("After Condition1")).endEvent().moveToLastGateway().intermediateCatchEvent("conditionalEvent").conditionalEventDefinition().condition("${var==2}")).conditionalEventDefinitionDone().userTask().name("After Condition2")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(EVENT_BASED_GATEWAY_ID).singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.setVariable(procInst.getId(), "var", (Object)1);
        execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId(EVENT_BASED_GATEWAY_ID).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        this.runtimeService.setVariable(procInst.getId(), "var", (Object)2);
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"After Condition2", (Object)task.getName());
    }

    protected void deployParallelProcessWithEventBasedGateway() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((EventBasedGatewayBuilder)((ParallelGatewayBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().parallelGateway().id(PARALLEL_GATEWAY_ID)).userTask(TASK_BEFORE_EVENT_BASED_GW_ID).eventBasedGateway().id(EVENT_BASED_GATEWAY_ID)).intermediateCatchEvent().conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().moveToNode(PARALLEL_GATEWAY_ID).userTask(TASK_BEFORE_SERVICE_TASK_ID).serviceTask().camundaClass(SetVariableDelegate.class.getName())).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    @Test
    public void testParallelProcessWithSetVariableBeforeReachingEventBasedGW() {
        this.deployParallelProcessWithEventBasedGateway();
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task taskBeforeEGW = (Task)this.taskService.createTaskQuery().taskDefinitionKey(TASK_BEFORE_EVENT_BASED_GW_ID).singleResult();
        Task taskBeforeServiceTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey(TASK_BEFORE_SERVICE_TASK_ID).singleResult();
        this.taskService.complete(taskBeforeServiceTask.getId());
        this.taskService.complete(taskBeforeEGW.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)taskQuery.singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testParallelProcessWithSetVariableAfterReachingEventBasedGW() {
        this.deployParallelProcessWithEventBasedGateway();
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task taskBeforeEGW = (Task)this.taskService.createTaskQuery().taskDefinitionKey(TASK_BEFORE_EVENT_BASED_GW_ID).singleResult();
        Task taskBeforeServiceTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey(TASK_BEFORE_SERVICE_TASK_ID).singleResult();
        this.taskService.complete(taskBeforeEGW.getId());
        this.taskService.complete(taskBeforeServiceTask.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"After Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)taskQuery.singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }
}

