/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.signal.DummyServiceTask;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class SignalEventExpressionNameTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testSignalCatchIntermediate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var", "TestVar");
        this.runtimeService.startProcessInstanceByKey("catchSignal", variables);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalCatchIntermediate.bpmn20.xml"})
    @Test
    public void testSignalCatchIntermediateActsOnEventReceive() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var", "TestVar");
        this.runtimeService.startProcessInstanceByKey("catchSignal", variables);
        this.runtimeService.signalEventReceived("alert-TestVar");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalCatchIntermediate.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalThrowIntermediate.bpmn20.xml"})
    @Test
    public void testSignalThrowCatchIntermediate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var", "TestVar");
        this.runtimeService.startProcessInstanceByKey("catchSignal", variables);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
        this.runtimeService.startProcessInstanceByKey("throwSignal", variables);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-${var}").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalCatchIntermediate.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalThrowEnd.bpmn20.xml"})
    @Test
    public void testSignalThrowEndCatchIntermediate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var", "TestVar");
        this.runtimeService.startProcessInstanceByKey("catchSignal", variables);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
        this.runtimeService.startProcessInstanceByKey("throwEndSignal", variables);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-${var}").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalCatchBoundary.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalThrowIntermediate.bpmn20.xml"})
    @Test
    public void testSignalCatchBoundary() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var", "TestVar");
        this.runtimeService.startProcessInstanceByKey("catchSignal", variables);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal", variables);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-TestVar").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalStartEvent.bpmn20.xml"})
    @Test
    public void testSignalStartEvent() {
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert-foo").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.signalEventReceived("alert-foo");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    @Test
    public void testSignalStartEventInEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalStartEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        this.runtimeService.signalEventReceived("alert-foo");
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.throwAlertSignalAsync.bpmn20.xml"})
    @Test
    public void testAsyncSignalStartEvent() {
        ProcessDefinition catchingProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("startBySignal").singleResult();
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)catchingProcessDefinition.getId(), (Object)processInstance.getProcessDefinitionId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventExpressionNameTest.testSignalCatchIntermediate.bpmn20.xml"})
    @Test
    public void testSignalExpressionErrorHandling() {
        String expectedErrorMessage = "Unknown property used in expression: alert-${var}. Cannot resolve identifier 'var'";
        HashMap variables = new HashMap();
        try {
            this.runtimeService.startProcessInstanceByKey("catchSignal", variables);
            Assert.fail((String)("exception expected: " + expectedErrorMessage));
        }
        catch (ProcessEngineException e) {
            Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").count());
        }
    }
}

