/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.standalone.history.CustomHistoryLevelIdentityLink;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CustomHistoryLevelIdentityLinkTest {
    @Parameterized.Parameter
    public List<HistoryEventTypes> eventTypes;
    static CustomHistoryLevelIdentityLink customHisstoryLevelIL = new CustomHistoryLevelIdentityLink();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setJdbcUrl("jdbc:h2:mem:" + CustomHistoryLevelIdentityLinkTest.class.getSimpleName());
        ArrayList<CustomHistoryLevelIdentityLink> levels = new ArrayList<CustomHistoryLevelIdentityLink>();
        levels.add(customHisstoryLevelIL);
        configuration.setCustomHistoryLevels(levels);
        configuration.setHistory("aCustomHistoryLevelIL");
        configuration.setDatabaseSchemaUpdate("create-drop");
    });
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Arrays.asList(HistoryEventTypes.IDENTITY_LINK_ADD)}, {Arrays.asList(HistoryEventTypes.IDENTITY_LINK_DELETE, HistoryEventTypes.IDENTITY_LINK_ADD)});
    }

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.taskService = this.engineRule.getTaskService();
        customHisstoryLevelIL.setEventTypes(this.eventTypes);
    }

    @After
    public void tearDown() {
        customHisstoryLevelIL.setEventTypes(null);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDeletingIdentityLinkByProcDefId() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("anAuthUser");
        this.taskService.addCandidateUser(taskId, "aUser");
        this.taskService.deleteCandidateUser(taskId, "aUser");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertTrue((historicIdentityLinks.size() > 0 ? 1 : 0) != 0);
        this.repositoryService.deleteProcessDefinitions().byKey("oneTaskProcess").cascade().delete();
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)0L, (long)historicIdentityLinks.size());
    }

    @Test
    public void testDeletingIdentityLinkByTaskId() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.setAuthenticatedUserId("anAuthUser");
        this.taskService.addCandidateUser(taskId, "aUser");
        this.taskService.deleteCandidateUser(taskId, "aUser");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertTrue((historicIdentityLinks.size() > 0 ? 1 : 0) != 0);
        this.taskService.deleteTask(taskId, true);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)0L, (long)historicIdentityLinks.size());
    }
}

