/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.metrics;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.metrics.Meter;

public class MetricsRegistry {
    protected Map<String, Meter> dbMeters = new HashMap<String, Meter>();
    protected Map<String, Meter> telemetryMeters = new HashMap<String, Meter>();
    protected boolean isCollectingTelemetryMetrics = false;

    public Meter getDbMeterByName(String name) {
        return this.dbMeters.get(name);
    }

    public Map<String, Meter> getDbMeters() {
        return this.dbMeters;
    }

    public Map<String, Meter> getTelemetryMeters() {
        return this.telemetryMeters;
    }

    public boolean isCollectingTelemetryMetrics() {
        return this.isCollectingTelemetryMetrics;
    }

    public void setCollectingTelemetryMetrics(boolean isCollectingTelemetryMetrics) {
        this.isCollectingTelemetryMetrics = isCollectingTelemetryMetrics;
    }

    public void markOccurrence(String name) {
        this.markOccurrence(name, 1L);
    }

    public void markOccurrence(String name, long times) {
        this.markOccurrence(this.dbMeters, name, times);
        if (this.isCollectingTelemetryMetrics) {
            this.markOccurrence(this.telemetryMeters, name, times);
        }
    }

    public void markTelemetryOccurrence(String name, long times) {
        this.markOccurrence(this.telemetryMeters, name, times);
    }

    protected void markOccurrence(Map<String, Meter> meters, String name, long times) {
        Meter meter = meters.get(name);
        if (meter != null) {
            meter.markTimes(times);
        }
    }

    public void createMeter(String name) {
        Meter dbMeter = new Meter(name);
        this.dbMeters.put(name, dbMeter);
        Meter telemetryMeter = new Meter(name);
        this.telemetryMeters.put(name, telemetryMeter);
    }

    public void createDbMeter(String name) {
        Meter dbMeter = new Meter(name);
        this.dbMeters.put(name, dbMeter);
    }
}

