/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.embedded;

import java.util.List;
import java.util.Set;
import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.application.ProcessApplicationDeploymentInfo;
import org.camunda.bpm.application.impl.embedded.TestApplicationReusingExistingEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithAdditionalResourceSuffixes;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithCustomDefaultEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithCustomEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithCustomName;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithResources;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithTenantId;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithoutEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithoutProcesses;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EmbeddedProcessApplicationTest
extends PluggableProcessEngineTest {
    protected RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
    protected boolean defaultEngineRegistered;

    public void registerProcessEngine() {
        this.runtimeContainerDelegate.registerProcessEngine(this.processEngine);
        this.defaultEngineRegistered = true;
    }

    @Before
    public void setUp() throws Exception {
        this.defaultEngineRegistered = false;
    }

    @After
    public void tearDown() {
        if (this.defaultEngineRegistered) {
            this.runtimeContainerDelegate.unregisterProcessEngine(this.processEngine);
        }
    }

    @Test
    public void testDeployAppWithoutEngine() {
        TestApplicationWithoutEngine processApplication = new TestApplicationWithoutEngine();
        processApplication.deploy();
        processApplication.undeploy();
    }

    @Test
    public void testDeployAppWithoutProcesses() {
        this.registerProcessEngine();
        TestApplicationWithoutProcesses processApplication = new TestApplicationWithoutProcesses();
        processApplication.deploy();
        ProcessEngine processEngine = BpmPlatform.getProcessEngineService().getDefaultProcessEngine();
        long deployments = processEngine.getRepositoryService().createDeploymentQuery().count();
        Assert.assertEquals((long)0L, (long)deployments);
        processApplication.undeploy();
    }

    @Test
    public void testDeployAppWithCustomEngine() {
        TestApplicationWithCustomEngine processApplication = new TestApplicationWithCustomEngine();
        processApplication.deploy();
        ProcessEngine processEngine = BpmPlatform.getProcessEngineService().getProcessEngine("embeddedEngine");
        Assert.assertNotNull((Object)processEngine);
        Assert.assertEquals((Object)"embeddedEngine", (Object)processEngine.getName());
        ProcessEngineConfigurationImpl configuration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        Assert.assertTrue((boolean)configuration.isJobExecutorDeploymentAware());
        Assert.assertTrue((boolean)configuration.isJobExecutorPreferTimerJobs());
        Assert.assertTrue((boolean)configuration.isJobExecutorAcquireByDueDate());
        Assert.assertEquals((long)5L, (long)configuration.getJdbcMaxActiveConnections());
        processApplication.undeploy();
    }

    @Test
    public void testDeployAppWithCustomDefaultEngine() {
        String processApplicationName = "test-app";
        String customEngineName = "customDefaultEngine";
        TestApplicationWithCustomDefaultEngine processApplication = new TestApplicationWithCustomDefaultEngine();
        processApplication.deploy();
        String deployedToProcessEngineName = ((ProcessApplicationDeploymentInfo)this.runtimeContainerDelegate.getProcessApplicationService().getProcessApplicationInfo(processApplicationName).getDeploymentInfo().get(0)).getProcessEngineName();
        Assert.assertEquals((Object)customEngineName, (Object)processApplication.getDefaultDeployToEngineName());
        Assert.assertEquals((Object)customEngineName, (Object)deployedToProcessEngineName);
        processApplication.undeploy();
    }

    @Test
    public void testDeployAppReusingExistingEngine() {
        this.registerProcessEngine();
        TestApplicationReusingExistingEngine processApplication = new TestApplicationReusingExistingEngine();
        processApplication.deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        processApplication.undeploy();
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }

    @Test
    public void testDeployAppWithAdditionalResourceSuffixes() {
        this.registerProcessEngine();
        TestApplicationWithAdditionalResourceSuffixes processApplication = new TestApplicationWithAdditionalResourceSuffixes();
        processApplication.deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertNotNull((Object)deployment);
        List deploymentResources = this.repositoryService.getDeploymentResources(deployment.getId());
        Assert.assertEquals((long)4L, (long)deploymentResources.size());
        processApplication.undeploy();
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }

    @Test
    public void testDeployAppWithResources() {
        this.registerProcessEngine();
        TestApplicationWithResources processApplication = new TestApplicationWithResources();
        processApplication.deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertNotNull((Object)deployment);
        List deploymentResources = this.repositoryService.getDeploymentResources(deployment.getId());
        Assert.assertEquals((long)4L, (long)deploymentResources.size());
        processApplication.undeploy();
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }

    @Test
    public void testDeploymentSourceProperty() {
        this.registerProcessEngine();
        TestApplicationWithResources processApplication = new TestApplicationWithResources();
        processApplication.deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertNotNull((Object)deployment);
        Assert.assertEquals((Object)"process application", (Object)deployment.getSource());
        processApplication.undeploy();
    }

    @Test
    public void testDeployProcessApplicationWithNameAttribute() {
        TestApplicationWithCustomName pa = new TestApplicationWithCustomName();
        pa.deploy();
        Set deployedPAs = this.runtimeContainerDelegate.getProcessApplicationService().getProcessApplicationNames();
        Assert.assertEquals((long)1L, (long)deployedPAs.size());
        Assert.assertTrue((boolean)deployedPAs.contains("foooooooo"));
        pa.undeploy();
    }

    @Test
    public void testDeployWithTenantIds() {
        this.registerProcessEngine();
        TestApplicationWithTenantId processApplication = new TestApplicationWithTenantId();
        processApplication.deploy();
        List deployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByTenantId().asc()).list();
        Assert.assertEquals((long)2L, (long)deployments.size());
        Assert.assertEquals((Object)"tenant1", (Object)((Deployment)deployments.get(0)).getTenantId());
        Assert.assertEquals((Object)"tenant2", (Object)((Deployment)deployments.get(1)).getTenantId());
        processApplication.undeploy();
    }

    @Test
    public void testDeployWithoutTenantId() {
        this.registerProcessEngine();
        TestApplicationWithResources processApplication = new TestApplicationWithResources();
        processApplication.deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assert.assertNotNull((Object)deployment);
        Assert.assertNull((Object)deployment.getTenantId());
        processApplication.undeploy();
    }
}

