/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DeleteTaskMetricsAuthorizationTest {
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngine processEngine;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ManagementService managementService;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        this.managementService = this.processEngine.getManagementService();
        this.identityService = this.processEngine.getIdentityService();
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.clearAuthentication();
        this.removeAdminUser();
    }

    @Test
    public void shouldDeleteTaskMetricsWithAuthorizedAdmin() {
        this.authenticateAdminUser();
        this.managementService.deleteTaskMetrics(null);
    }

    @Test
    public void shouldThrowExceptionWhenDeleteTaskMetricsWithAuthorizedNonAdmin() {
        this.authenticateUser();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.deleteTaskMetrics(null)).isInstanceOf(AuthorizationException.class)).hasMessageContaining("Required admin authenticated group or user.");
    }

    protected void authenticateAdminUser() {
        this.processEngineConfiguration.getAdminUsers().add("user");
        this.authenticateUser();
    }

    protected void authenticateUser() {
        this.identityService.setAuthentication("user", null, null);
    }

    protected void removeAdminUser() {
        this.processEngineConfiguration.getAdminUsers().remove("user");
    }
}

