/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.dmn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DecisionRequirementsDefinitionQueryAuthorizationTest {
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String ANOTHER_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DEFINITION_KEY = "score";
    protected static final String ANOTHER_DEFINITION_KEY = "dish";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter(value=0)
    public AuthorizationScenario scenario;
    @Parameterized.Parameter(value=1)
    public String[] expectedDefinitionKeys;

    @Parameterized.Parameters(name="scenario {index}")
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({AuthorizationScenario.scenario().withoutAuthorizations().succeeds(), DecisionRequirementsDefinitionQueryAuthorizationTest.expectedDefinitions(new String[0])}, {AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, DEFINITION_KEY, "userId", new Permission[]{Permissions.READ})).succeeds(), DecisionRequirementsDefinitionQueryAuthorizationTest.expectedDefinitions(DEFINITION_KEY)}, {AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, "*", "userId", new Permission[]{Permissions.READ})).succeeds(), DecisionRequirementsDefinitionQueryAuthorizationTest.expectedDefinitions(DEFINITION_KEY, ANOTHER_DEFINITION_KEY)}, {AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, DEFINITION_KEY, "userId", new Permission[]{Permissions.READ}), AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, "*", "userId", new Permission[]{Permissions.READ})).succeeds(), DecisionRequirementsDefinitionQueryAuthorizationTest.expectedDefinitions(DEFINITION_KEY, ANOTHER_DEFINITION_KEY)});
    }

    @Before
    public void setUp() throws Exception {
        this.authRule.createUserAndGroup("userId", "groupId");
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void queryDecisionRequirementsDefinitions() {
        this.authRule.init(this.scenario).withUser("userId").bindResource("decisionRequirementsDefinitionKey", DEFINITION_KEY).start();
        DecisionRequirementsDefinitionQuery query = this.engineRule.getRepositoryService().createDecisionRequirementsDefinitionQuery();
        long count = query.count();
        List definitions = query.list();
        if (this.authRule.assertScenario(this.scenario)) {
            Assertions.assertThat((long)count).isEqualTo((long)this.expectedDefinitionKeys.length);
            List<String> definitionKeys = this.getDefinitionKeys(definitions);
            Assertions.assertThat(definitionKeys).containsExactlyInAnyOrder((Object[])this.expectedDefinitionKeys);
        }
    }

    protected List<String> getDefinitionKeys(List<DecisionRequirementsDefinition> definitions) {
        ArrayList<String> definitionKeys = new ArrayList<String>();
        for (DecisionRequirementsDefinition definition : definitions) {
            definitionKeys.add(definition.getKey());
        }
        return definitionKeys;
    }

    protected static String[] expectedDefinitions(String ... keys) {
        return keys;
    }
}

