/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.license;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LicenseKeyDirtyDbTest {
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule);
    ProcessEngine processEngine;
    ProcessEngineConfigurationImpl processEngineConfiguration;
    ManagementService managementService;

    @Before
    public void init() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        this.managementService = this.processEngine.getManagementService();
        this.managementService.setLicenseKey("license");
    }

    @AfterClass
    public static void cleanup() {
        new ProvidedProcessEngineRule().getProcessEngine().getManagementService().deleteLicenseKey();
    }

    @Test
    public void testDirtyDatabaseOnlyLicenseKey() {
        String licenseKey = this.managementService.getLicenseKey();
        Long byteArrayCount = this.queryByteArrayTableSize();
        Assertions.assertThat((String)licenseKey).isNotEmpty();
        Assertions.assertThat((Long)byteArrayCount).isEqualTo(1L);
    }

    private Long queryByteArrayTableSize() {
        return (Long)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Long>(){

            public Long execute(CommandContext commandContext) {
                String tablePrefix = LicenseKeyDirtyDbTest.this.processEngineConfiguration.getDatabaseTablePrefix();
                return (Long)commandContext.getProcessEngineConfiguration().getManagementService().getTableCount().get(tablePrefix + "ACT_GE_BYTEARRAY");
            }
        });
    }
}

