/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.time.Instant;
import java.util.Date;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class TaskMetricsTest {
    protected static final String PROCESS_KEY = "process";
    protected static final BpmnModelInstance USER_TASK_PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task").camundaAssignee("kermit")).endEvent().done();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(config -> config.setTaskMetricsEnabled(true));
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    @Rule
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ManagementService managementService;
    protected TaskService taskService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
    }

    @After
    public void cleanUp() {
        this.managementService.deleteTaskMetrics(null);
        this.testRule.deleteAllStandaloneTasks();
    }

    @Test
    public void shouldDeleteTaskMetrics() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
        this.managementService.deleteTaskMetrics(null);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(0L);
    }

    @Test
    public void shouldDeleteTaskMetricsWithTimestamp() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
        this.managementService.deleteTaskMetrics(this.getOneMinuteFromNow());
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(0L);
    }

    @Test
    public void shouldNotDeleteTaskMetricsWithTimestampBefore() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
        this.managementService.deleteTaskMetrics(this.getOneMinuteAgo());
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldGetUniqueTaskWorkerCountForSameAssigneeOnDifferentTasksAsOne() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldGetUniqueTaskWorkerCountWithStartDateInclusive() {
        this.testRule.deploy(USER_TASK_PROCESS);
        ClockUtil.setCurrentTime((Date)new Date(4000L));
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        ClockUtil.setCurrentTime((Date)new Date(5000L));
        this.taskService.setAssignee(((Task)this.taskService.createTaskQuery().singleResult()).getId(), "gonzo");
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(new Date(5000L), null)).isEqualTo(1L);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(new Date(4000L), null)).isEqualTo(2L);
    }

    @Test
    public void shouldGetUniqueTaskWorkerCountWithEndDateExclusive() {
        this.testRule.deploy(USER_TASK_PROCESS);
        ClockUtil.setCurrentTime((Date)new Date(4000L));
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        ClockUtil.setCurrentTime((Date)new Date(5000L));
        this.taskService.setAssignee(((Task)this.taskService.createTaskQuery().singleResult()).getId(), "gonzo");
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, new Date(5000L))).isEqualTo(1L);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, new Date(6000L))).isEqualTo(2L);
    }

    @Test
    public void shouldGetUniqueTaskWorkerCountWithoutStartDate() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, this.getOneMinuteFromNow())).isEqualTo(1L);
    }

    @Test
    public void shouldGetUniqueTaskWorkerCountWithoutEndDate() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(this.getOneMinuteAgo(), null)).isEqualTo(1L);
    }

    @Test
    public void shouldGetUniqueTaskWorkerCountWithoutDates() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldCreateTaskMetricWithAssignmentByTaskListener() {
        this.testRule.deploy(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("task").camundaTaskListenerClass("create", AssignmentTaskListener.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldCreateTaskMetricWithAssignmentByCamundaAssigneeExtension() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    @Deployment
    public void shouldCreateTaskMetricWithAssignmentByHumanPerformer() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldCreateTaskMetricsWithMultipleAssignments() {
        this.testRule.deploy(((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("task").camundaAssignee("kermit")).camundaTaskListenerClass("create", AssignmentTaskListener.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(2L);
    }

    @Test
    public void shouldCreateTaskMetricOnDelegation() {
        this.testRule.deploy(USER_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.delegateTask(taskId, "gonzo");
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(2L);
    }

    @Test
    public void shouldCreateTaskMetricOnClaim() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("task").endEvent().done());
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.claim(taskId, "gonzo");
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldCreateTaskMetricsWithinErrorMarginWithHigherLoadOfAssignments() {
        long taskWorkers = 3500L;
        long lowerErrorBoundary = Math.floorDiv(taskWorkers * 90L, 100L);
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("task").endEvent().done());
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        LongStream.range(0L, taskWorkers).forEach(i -> this.taskService.setAssignee(taskId, "kermit" + i));
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isGreaterThan(lowerErrorBoundary).isLessThanOrEqualTo(taskWorkers);
    }

    @Test
    public void shouldNotCreateTaskMetricForTransientStandaloneTask() {
        Task newTask = this.taskService.newTask();
        newTask.setAssignee("kermit");
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(0L);
    }

    @Test
    public void shouldCreateTaskMetricWhenInsertingStandaloneTask() {
        Task newTask = this.taskService.newTask();
        newTask.setAssignee("kermit");
        this.taskService.saveTask(newTask);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldCreateTaskMetricWhenUpdatingStandaloneTask() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        newTask.setAssignee("kermit");
        this.taskService.saveTask(newTask);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldCreateTaskMetricWhenUpdatingStandaloneTaskInCommandContext() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(c -> {
            TaskEntity task = c.getTaskManager().findTaskById(newTask.getId());
            task.setAssignee("kermit");
            return null;
        });
        Assertions.assertThat((String)((Task)this.taskService.createTaskQuery().taskId(newTask.getId()).singleResult()).getAssignee()).isEqualTo((Object)"kermit");
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    @Test
    public void shouldCreateTaskMetricForAssignmentOnStandaloneTask() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        this.taskService.setAssignee(newTask.getId(), "kermit");
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
    }

    protected Date getOneMinuteFromNow() {
        return Date.from(Instant.now().plusSeconds(60L));
    }

    protected Date getOneMinuteAgo() {
        return Date.from(Instant.now().minusSeconds(60L));
    }

    public static class AssignmentTaskListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            delegateTask.setAssignee("gonzo");
        }
    }
}

